/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.wechat;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.plugins.auth.AuthTools;
import com.af.v4.system.common.plugins.http.RestTools;
import com.af.v4.system.common.plugins.wechat.WechatApi;
import com.af.v4.system.common.redis.RedisService;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WechatAuthUtils
extends AuthTools<JSONObject, String> {
    static final Logger LOGGER = LoggerFactory.getLogger(WechatAuthUtils.class);

    public WechatAuthUtils(RedisService redisService) {
        super(redisService);
    }

    @Override
    protected AuthTools.AuthResult getToken(String orgId, JSONObject authParams) {
        String appid = authParams.getString("appid");
        String secret = authParams.getString("secret");
        Boolean forceRefresh = authParams.optBoolean("forceRefresh", false);
        JSONObject content = new JSONObject();
        content.put("grant_type", (Object)"client_credential");
        content.put("appid", (Object)appid);
        content.put("secret", (Object)secret);
        content.put("force_refresh", (Object)forceRefresh);
        JSONObject result = new JSONObject(RestTools.post(WechatApi.getAuthUrl(), content));
        if (result.has("errcode")) {
            throw new ServiceException(result.toString());
        }
        String accessToken = result.getString("access_token");
        int expiresIn = result.getInt("expires_in");
        return new AuthTools.AuthResult(this, accessToken, expiresIn - 180);
    }

    @Override
    protected String getName() {
        return "Wechat";
    }

    @Override
    protected boolean supportsParameterlessAuth() {
        return false;
    }
}

