/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.http.core.response;

import com.af.v4.system.common.plugins.http.core.BaseHttpPoolUtil;
import com.af.v4.system.common.plugins.http.core.response.AsyncResponse;
import java.io.IOException;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.core5.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

public class DefaultAsyncResponse
implements AsyncResponse {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultAsyncResponse.class);
    protected final StopWatch stopWatch = new StopWatch();
    private String url;
    private String headers;
    private String body;
    private Boolean isStandardResponse;

    @Override
    public void setContext(String url, String headers, String body, Boolean isStandardResponse) {
        this.url = url;
        this.headers = headers;
        this.body = body;
        if (!this.stopWatch.isRunning()) {
            this.stopWatch.start();
        }
        this.isStandardResponse = isStandardResponse;
    }

    public void completed(SimpleHttpResponse response) {
        this.getAndPrintResponse((HttpResponse)response);
    }

    public void failed(Exception ex) {
        String responseData;
        if (ex instanceof IOException) {
            IOException ioException = (IOException)ex;
            responseData = BaseHttpPoolUtil.buildErrorResult(ioException);
        } else {
            responseData = "''";
            logger.error("\u5f02\u6b65\u8bf7\u6c42\u65f6\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)ex);
        }
        BaseHttpPoolUtil.stop(this.stopWatch);
        BaseHttpPoolUtil.printLog(logger, "async", this.stopWatch, this.url, this.headers, this.body, responseData);
    }

    public void cancelled() {
        BaseHttpPoolUtil.stop(this.stopWatch);
    }

    protected String getAndPrintResponse(HttpResponse response) {
        try {
            String responseData = BaseHttpPoolUtil.getResponseData(response, this.isStandardResponse);
            BaseHttpPoolUtil.stop(this.stopWatch);
            BaseHttpPoolUtil.printLog(logger, "async", this.stopWatch, this.url, this.headers, this.body, responseData);
            return responseData;
        }
        catch (Exception e) {
            this.failed(e);
            return null;
        }
    }
}

