/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.http.core;

import com.af.v4.system.common.plugins.http.config.HttpClientConfig;
import com.af.v4.system.common.plugins.http.core.BaseHttpPoolUtil;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.HostnameVerifier;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.HostnameVerificationPolicy;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHeaderElementIterator;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

public class HttpConnectionPoolUtil
extends BaseHttpPoolUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpConnectionPoolUtil.class);
    private static final String HTTP_CLIENT_KEY = "http";
    private static final Map<String, CloseableHttpClient> CLIENT_MAP = new ConcurrentHashMap<String, CloseableHttpClient>(3);

    private static CloseableHttpClient createHttpClient(String clientKey, TlsSocketStrategy sslSocketFactory) {
        return CLIENT_MAP.computeIfAbsent(clientKey, key -> {
            TlsSocketStrategy realTlsSocketStrategy;
            HttpClientConfig config = new HttpClientConfig.Builder().build();
            if (sslSocketFactory == null) {
                try {
                    realTlsSocketStrategy = new DefaultClientTlsStrategy(SSLContexts.custom().loadTrustMaterial((TrustStrategy)TrustAllStrategy.INSTANCE).build(), HostnameVerificationPolicy.CLIENT, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                }
                catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            } else {
                realTlsSocketStrategy = sslSocketFactory;
            }
            PoolingHttpClientConnectionManager manager = PoolingHttpClientConnectionManagerBuilder.create().setTlsSocketStrategy(realTlsSocketStrategy).setMaxConnTotal(HttpClientConfig.HTTP_MAX_POOL_SIZE.intValue()).setMaxConnPerRoute(HttpClientConfig.HTTP_MAX_ROUTE_SIZE.intValue()).setDefaultConnectionConfig(ConnectionConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)config.getConnectTimeout().intValue())).build()).build();
            return HttpClients.custom().setKeepAliveStrategy((response, context) -> {
                BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
                while (it.hasNext()) {
                    HeaderElement he = (HeaderElement)it.next();
                    String param = he.getName();
                    String value = he.getValue();
                    if (value == null || !"timeout".equalsIgnoreCase(param)) continue;
                    try {
                        return TimeValue.ofSeconds((long)Long.parseLong(value));
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
                return TimeValue.ofSeconds((long)5L);
            }).setConnectionManager((HttpClientConnectionManager)manager).setRetryStrategy((HttpRequestRetryStrategy)new DefaultHttpRequestRetryStrategy(0, TimeValue.ZERO_MILLISECONDS)).evictExpiredConnections().evictIdleConnections(TimeValue.ofMilliseconds((long)HttpClientConfig.HTTP_IDEL_TIME_OUT.intValue())).setDefaultRequestConfig(RequestConfig.custom().setResponseTimeout(Timeout.ofMilliseconds((long)config.getSocketTimeout().intValue())).build()).build();
        });
    }

    public static CloseableHttpClient getHttpClient(String tlsName, TlsSocketStrategy sslSocketFactory) {
        String clientKeyName = sslSocketFactory == null ? HTTP_CLIENT_KEY : tlsName;
        return HttpConnectionPoolUtil.createHttpClient(clientKeyName, sslSocketFactory);
    }

    public static CloseableHttpClient getHttpClient() {
        return HttpConnectionPoolUtil.getHttpClient(null, null);
    }

    public static String request(String value, String headersStr, HttpClientConfig config, Boolean isStandardResponse, HttpUriRequestBase base) {
        return HttpConnectionPoolUtil.request(value, headersStr, config, base, isStandardResponse, null);
    }

    public static String request(String value, String headersStr, HttpClientConfig config, HttpUriRequestBase base) {
        return HttpConnectionPoolUtil.request(value, headersStr, config, false, base);
    }

    public static String requestFormUrlEncoded(String value, String headersStr, HttpClientConfig config, Boolean isStandardResponse, HttpUriRequestBase base) {
        return HttpConnectionPoolUtil.requestFormUrlEncoded(value, headersStr, config, base, isStandardResponse, null);
    }

    public static String requestFormUrlEncoded(String value, String headersStr, HttpClientConfig config, HttpUriRequestBase base) {
        return HttpConnectionPoolUtil.requestFormUrlEncoded(value, headersStr, config, false, base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String request(String value, String headersStr, HttpClientConfig config, HttpUriRequestBase base, Boolean isStandardResponse, CloseableHttpClient httpClient) {
        String url = base.getScheme() + "://" + String.valueOf(base.getAuthority()) + base.getPath();
        if (httpClient == null) {
            httpClient = HttpConnectionPoolUtil.getHttpClient();
        }
        HttpConnectionPoolUtil.setRequestConfig(config, base);
        HttpConnectionPoolUtil.setHeaders((HttpRequest)base, headersStr);
        if (base.getEntity() == null) {
            HttpConnectionPoolUtil.setBody((HttpRequest)base, value);
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        AtomicReference<String> result = new AtomicReference<String>();
        try {
            httpClient.execute((ClassicHttpRequest)base, (HttpContext)HttpClientContext.create(), response -> {
                String responseContext = HttpConnectionPoolUtil.getResponseData((HttpResponse)response, isStandardResponse);
                result.set(responseContext);
                return response;
            });
        }
        catch (IOException e) {
            result.set(BaseHttpPoolUtil.buildErrorResult(e));
        }
        finally {
            BaseHttpPoolUtil.printLog(LOGGER, "sync", stopWatch, url, headersStr, value, (String)result.get());
        }
        return (String)result.get();
    }

    public static String requestFormUrlEncoded(String value, String headersStr, HttpClientConfig config, HttpUriRequestBase base, Boolean isStandardResponse, CloseableHttpClient httpClient) {
        HttpConnectionPoolUtil.setUrlEncodedBody((ClassicHttpRequest)base, value);
        return HttpConnectionPoolUtil.request(value, headersStr, config, base, isStandardResponse, httpClient);
    }

    public static String requestFormUrlEncoded(String value, String headersStr, HttpClientConfig config, HttpUriRequestBase base, CloseableHttpClient httpClient) {
        return HttpConnectionPoolUtil.requestFormUrlEncoded(value, headersStr, config, base, false, httpClient);
    }
}

