package com.af.v4.system.common.plugins.http.core.response;

import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;

/**
 * 标准异步响应实现
 *
 * @author Mr.river
 * @apiNote 自行根据成功和失败的响应处理
 */
public class StandardAsyncResponse extends DefaultAsyncResponse {

    private final SuccessHandler successHandler;

    private final ErrorHandler errorHandler;

    public StandardAsyncResponse(SuccessHandler successHandler, ErrorHandler errorHandler) {
        this.successHandler = successHandler;
        this.errorHandler = errorHandler;
    }

    public StandardAsyncResponse(SuccessHandler successHandler) {
        this.successHandler = successHandler;
        this.errorHandler = e -> {
        };
    }


    @Override
    public void completed(SimpleHttpResponse response) {
        String result = super.getAndPrintResponse(response);
        successHandler.run(result);
    }

    @Override
    public void failed(Exception ex) {
        super.failed(ex);
        errorHandler.run(ex);
    }

    @Override
    public void cancelled() {

    }

    public interface SuccessHandler {
        void run(String response);
    }

    public interface ErrorHandler {
        void run(Exception e);
    }
}
