package com.af.v4.system.common.plugins.http.core.response;

import com.af.v4.system.common.plugins.http.core.BaseHttpPoolUtil;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;

/**
 * 空异步响应实现
 *
 * @author Mr.river
 * @apiNote 成功时无处理，失败时打印日志
 */
public class EmptyAsyncResponse extends DefaultAsyncResponse {

    @Override
    public void completed(SimpleHttpResponse response) {
        BaseHttpPoolUtil.stop(stopWatch);
    }

    @Override
    public void failed(Exception ex) {
        BaseHttpPoolUtil.stop(stopWatch);
        logger.error("异步请求时发生异常：", ex);
    }

    @Override
    public void cancelled() {
        super.cancelled();
    }
}
