package com.af.v4.system.common.plugins.http.core.response;

import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.core5.concurrent.FutureCallback;

/**
 * 通用异步响应接口，便于统一上下文和日志打印
 */
public interface AsyncResponse extends FutureCallback<SimpleHttpResponse> {

    /**
     * 设置当前请求的上下文信息，便于响应时统一打印
     *
     * @param url                请求地址
     * @param headers            请求头
     * @param body               请求体
     * @param isStandardResponse 是否是标准响应（返回响应body和header）
     */
    void setContext(String url, String headers, String body, Boolean isStandardResponse);
}

