/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.core;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class PriceFormatTools {
    static final NumberFormat NF = NumberFormat.getInstance();
    static final NumberFormat NF_TWO_DECIMAL;

    public static void formatNumber(JSONObject object) {
        PriceFormatTools.formatNumberWithFormat(object, NF);
    }

    public static void formatNumber(JSONArray object) {
        PriceFormatTools.formatNumberWithFormat(object, NF);
    }

    public static void formatNumberTwoDecimal(JSONObject object) {
        PriceFormatTools.formatNumberWithFormat(object, NF_TWO_DECIMAL);
    }

    public static void formatNumberTwoDecimal(JSONArray object) {
        PriceFormatTools.formatNumberWithFormat(object, NF_TWO_DECIMAL);
    }

    public static void formatNumber(JSONObject object, String ... excludeFields) {
        PriceFormatTools.formatNumberWithFormat(object, NF, excludeFields);
    }

    public static void formatNumber(JSONArray object, String ... excludeFields) {
        PriceFormatTools.formatNumberWithFormat(object, NF, excludeFields);
    }

    public static void formatNumberTwoDecimal(JSONObject object, String ... excludeFields) {
        PriceFormatTools.formatNumberWithFormat(object, NF_TWO_DECIMAL, excludeFields);
    }

    public static void formatNumberTwoDecimal(JSONArray object, String ... excludeFields) {
        PriceFormatTools.formatNumberWithFormat(object, NF_TWO_DECIMAL, excludeFields);
    }

    private static void formatNumberWithFormat(JSONObject object, NumberFormat formatter) {
        PriceFormatTools.formatNumberWithFormat(object, formatter, new String[0]);
    }

    private static void formatNumberWithFormat(JSONArray object, NumberFormat formatter) {
        PriceFormatTools.formatNumberWithFormat(object, formatter, new String[0]);
    }

    private static void formatNumberWithFormat(JSONObject object, NumberFormat formatter, String[] excludeFields) {
        HashSet<String> excludeSet = new HashSet<String>(Arrays.asList(excludeFields));
        Iterator iterator = object.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = object.get(key);
            if (value instanceof BigDecimal) {
                if (excludeSet.contains(key)) continue;
                object.put(key, (Object)PriceFormatTools.formatNumberBase(value, formatter));
                continue;
            }
            if (value instanceof JSONObject) {
                PriceFormatTools.formatNumberWithFormat((JSONObject)value, formatter, excludeFields);
                continue;
            }
            if (!(value instanceof JSONArray)) continue;
            PriceFormatTools.formatNumberWithFormat((JSONArray)value, formatter, excludeFields);
        }
    }

    private static void formatNumberWithFormat(JSONArray object, NumberFormat formatter, String[] excludeFields) {
        Iterator iterator = object.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Object value = iterator.next();
            if (value instanceof BigDecimal) {
                object.put(index, (Object)PriceFormatTools.formatNumberBase(value, formatter));
            } else if (value instanceof JSONObject) {
                PriceFormatTools.formatNumberWithFormat((JSONObject)value, formatter, excludeFields);
            } else if (value instanceof JSONArray) {
                PriceFormatTools.formatNumberWithFormat((JSONArray)value, formatter, excludeFields);
            }
            ++index;
        }
    }

    public static String formatNumberBase(Object value) {
        return NF.format(value);
    }

    private static String formatNumberBase(Object value, NumberFormat formatter) {
        return formatter.format(value);
    }

    public static String formatNumberBaseTwoDecimal(Object value) {
        return NF_TWO_DECIMAL.format(value);
    }

    static {
        NF.setGroupingUsed(false);
        NF.setMinimumFractionDigits(2);
        NF.setMaximumFractionDigits(4);
        NF_TWO_DECIMAL = NumberFormat.getInstance();
        NF_TWO_DECIMAL.setGroupingUsed(false);
        NF_TWO_DECIMAL.setMinimumFractionDigits(2);
        NF_TWO_DECIMAL.setMaximumFractionDigits(2);
    }
}

