package com.af.v4.system.common.plugins.other;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Base64;

public class Base64Tools {

    private static final int CACHE_SIZE = 1024;

    public static String decode(String base64) {
        byte[] decodedBytes = Base64.getDecoder().decode(base64);
        return new String(decodedBytes, StandardCharsets.UTF_8);
    }

    public static String encode(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static byte[] decodeBuffer(String base64) {
        return Base64.getDecoder().decode(base64);
    }

    public static byte[] encodeBuffer(byte[] bytes) {
        return Base64.getEncoder().encode(bytes);
    }

    public static String encodeFile(String filePath) throws Exception {
        byte[] bytes = fileToByte(filePath);
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static byte[] fileToByte(String filePath) throws Exception {
        return Files.readAllBytes(Paths.get(filePath));
    }

    public static void byteArrayToFile(byte[] bytes, String filePath) throws Exception {
        Files.write(Paths.get(filePath), bytes);
    }

    /**
     * 对给定的字符串进行base64解码操作
     */
    public static String decodeData(String inputData) {
        return decode(inputData);
    }

    /**
     * 对给定的字符串进行base64加密操作
     */
    public static String encodeData(String inputData) {
        byte[] decodedBytes = Base64.getEncoder().encode(inputData.getBytes());
        return new String(decodedBytes, StandardCharsets.UTF_8);
    }

    /**
     * 十六进制字符串转Base64
     * @param hexString 十六进制字符串
     * @return Base64字符串
     */
    public static String hexToBase64(String hexString) {
        try {
            // 将十六进制字符串转换为字节数组
            byte[] bytes = new byte[hexString.length() / 2];
            for (int i = 0; i < hexString.length(); i += 2) {
                bytes[i / 2] = (byte) ((Character.digit(hexString.charAt(i), 16) << 4)
                        + Character.digit(hexString.charAt(i + 1), 16));
            }
            // 转换为Base64
            return Base64.getEncoder().encodeToString(bytes);
        } catch (Exception e) {
            throw new RuntimeException("十六进制转Base64失败", e);
        }
    }

}
