package com.af.v4.system.common.payment.dto;

import com.af.v4.system.common.payment.utils.PaymentUtils;
import org.json.JSONObject;

/**
 * 撤销订单返回参数
 */
public class CancelPaymentResponse {
    /**
     * 返回码
     */
    private String code;
    /**
     * 返回描述
     */
    private String message;
    /**
     * 商户号
     */
    private String mchId;
    /**
     * 商户订单号（业务系统生成的唯一订单号）
     */
    private String orderNo;
    /**
     * 撤销结果
     */
    private String cancelResult;
    /**
     * 请求报文
     */
    private JSONObject requestJson;

    public JSONObject buildJson(){
        return  PaymentUtils.toJson(this);
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMchId() {
        return mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getCancelResult() {
        return cancelResult;
    }

    public void setCancelResult(String cancelResult) {
        this.cancelResult = cancelResult;
    }

    public JSONObject getRequestJson() {
        return requestJson;
    }

    public void setRequestJson(JSONObject requestJson) {
        this.requestJson = requestJson;
    }
}