/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.handler.impl.rcb;

import com.af.v4.system.common.payment.annotation.PaymentHandlerConfig;
import com.af.v4.system.common.payment.dto.CancelPaymentRequest;
import com.af.v4.system.common.payment.dto.CancelPaymentResponse;
import com.af.v4.system.common.payment.dto.DownloadReconciliationFileRequest;
import com.af.v4.system.common.payment.dto.DownloadReconciliationFileResponse;
import com.af.v4.system.common.payment.dto.PaymentOrderRequest;
import com.af.v4.system.common.payment.dto.PaymentOrderResponse;
import com.af.v4.system.common.payment.dto.QueryPaymentStatusRequest;
import com.af.v4.system.common.payment.dto.QueryPaymentStatusResponse;
import com.af.v4.system.common.payment.dto.QueryRefundStatusRequest;
import com.af.v4.system.common.payment.dto.QueryRefundStatusResponse;
import com.af.v4.system.common.payment.dto.RefundPaymentRequest;
import com.af.v4.system.common.payment.dto.RefundPaymentResponse;
import com.af.v4.system.common.payment.enums.BankName;
import com.af.v4.system.common.payment.enums.IntegrationType;
import com.af.v4.system.common.payment.enums.PaymentStatus;
import com.af.v4.system.common.payment.exceptions.PaymentException;
import com.af.v4.system.common.payment.handler.impl.AbstractPaymentHandler;
import com.af.v4.system.common.payment.utils.PaymentUtils;
import com.af.v4.system.common.plugins.date.DateTools;
import com.af.v4.system.common.plugins.http.RestTools;
import com.af.v4.system.common.plugins.json.JsonTools;
import com.af.v4.system.common.plugins.other.Base64Tools;
import com.af.v4.system.common.redis.RedisService;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@PaymentHandlerConfig(bankName=BankName.AN_RCB, integrationTypes={IntegrationType.AGGREGATE, IntegrationType.SCAN_DEVICE})
public class AHRcbPaymentHandlerImpl
extends AbstractPaymentHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AHRcbPaymentHandlerImpl.class);
    private final RedisService redisService;
    private final String SUCCESS_CODE = "00";

    public AHRcbPaymentHandlerImpl(RedisService redisService) {
        this.redisService = redisService;
    }

    private JSONObject buildCommonParams(JSONObject paymentConfig) {
        LOGGER.info(">>> \u6784\u5efa\u516c\u5171\u8bf7\u6c42\u53c2\u6570");
        try {
            String batchNo = this.getBatchNo(paymentConfig);
            return new JSONObject().put("merchantNo", (Object)paymentConfig.optString("mchId")).put("terminalNo", (Object)paymentConfig.optString("posId")).put("batchNo", (Object)batchNo).put("traceNo", this.redisService.incr(this.generateTrackingNoKey(paymentConfig), -1L, 999999L, AHRcbPaymentHandlerImpl.secondsUntilTomorrow())).put("outTradeNo", (Object)PaymentUtils.generateSerialNumber()).put("nonceStr", (Object)PaymentUtils.generateOrderId());
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u516c\u5171\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.BUILD_PARAMETER_FAILED);
        }
    }

    @Override
    protected JSONObject buildPayOrderRequestParams(PaymentOrderRequest request, JSONObject paymentConfig) {
        LOGGER.info(">>> \u6784\u5efa\u626b\u7801\u6536\u6b3e\u8bf7\u6c42\u53c2\u6570");
        try {
            JSONObject params = this.buildCommonParams(paymentConfig).put("transAmount", request.getAmount()).put("remark", (Object)request.getDescription());
            String authCode = request.getAuthCode();
            if (!Objects.isNull(authCode)) {
                params.put("url", (Object)"/microPay");
                params.put("payCode", (Object)authCode);
            } else {
                params.put("url", (Object)"/nativePay");
            }
            return params;
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u652f\u4ed8\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR, request.toString());
        }
    }

    @Override
    protected PaymentOrderResponse processPayOrderResponse(PaymentOrderResponse response, PaymentOrderRequest request, JSONObject resultJson, JSONObject paymentConfig) {
        LOGGER.info(">>> \u5904\u7406\u83b7\u53d6\u4e8c\u7ef4\u7801\u54cd\u5e94\u7ed3\u679c");
        try {
            if ("00".equals(resultJson.optString("resultCode"))) {
                response.setState(PaymentStatus.PAY_SUCCESS);
                response.setMchId(resultJson.optString("merchantNo"));
                String qrUrlBase64 = resultJson.optString("qrUrl");
                String qrUrl = Base64Tools.decode((String)qrUrlBase64);
                response.setPayUrl(qrUrl);
                response.setCustomParam(new JSONObject().put("payImgUrl", (Object)resultJson.optString("qrUrl")).toString());
                response.setNeedQuery(true);
                response.setOrderNo(request.getOrderNo());
                response.setPayResult("\u4ea4\u6613\u6210\u529f");
            } else {
                LOGGER.info(">>> \u83b7\u53d6\u4e8c\u7ef4\u7801\u94f6\u884c\u8fd4\u56de\u5931\u8d25\uff01");
                response.setState(PaymentStatus.COMMUNICATION_FAIL);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u652f\u4ed8\u8ba2\u5355\u8fd4\u56de\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
        return response;
    }

    @Override
    protected JSONObject buildQueryPaymentStatusRequestParams(QueryPaymentStatusRequest request, JSONObject paymentConfig) {
        LOGGER.info(">>> \u6784\u5efa\u8ba2\u5355\u72b6\u6001\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570");
        try {
            return this.buildCommonParams(paymentConfig).put("outTradeNo", (Object)request.getOrderNo()).put("url", (Object)"/orderQuery");
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u652f\u4ed8\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.QUERY_REFUND_BUILD_REQUEST_PARAM_ERROR, request.toString());
        }
    }

    @Override
    protected QueryPaymentStatusResponse processQueryPaymentStatusResponse(QueryPaymentStatusResponse response, QueryPaymentStatusRequest request, JSONObject resultJson) {
        LOGGER.info(">>> \u5904\u7406\u8ba2\u5355\u67e5\u8be2\u54cd\u5e94\u7ed3\u679c");
        try {
            if ("00".equals(resultJson.optString("resultCode"))) {
                String tradeState;
                response.setState(PaymentStatus.PAY_SUCCESS);
                response.setMchId(resultJson.optString("merchantNo"));
                response.setOrderNo(request.getOrderNo());
                response.setTransactionId(resultJson.optString("chnOrderId", resultJson.optString("cposOrderId")));
                response.setAmount(resultJson.optInt("transAmount"));
                PaymentStatus status = switch (tradeState = resultJson.optString("orderStatus")) {
                    case "3" -> PaymentStatus.SUCCESS_FOR_PAYMENT;
                    case "6", "7" -> PaymentStatus.REFUND_FOR_PAYMENT;
                    case "1", "2", "8" -> PaymentStatus.NOT_FOR_PAYMENT;
                    case "5" -> PaymentStatus.ORDER_BEEN_CLOSED;
                    default -> PaymentStatus.FAIL_FOR_PAYMENT;
                };
                response.setPaymentStatus(status.getMessage());
                response.setState(status);
                response.setPaySuccessDate(DateTools.formatDateTime((String)resultJson.optString("paidTime", resultJson.optString("paidTime", DateTools.getNow((String)"yyyyMMddHHmmss")))));
            } else {
                LOGGER.info(">>> \u8ba2\u5355\u72b6\u6001\u67e5\u8be2\u94f6\u884c\u8fd4\u56de\u5931\u8d25\uff01");
                response.setState(PaymentStatus.PAY_FAIL);
            }
        }
        catch (Exception e) {
            LOGGER.error(">>> \u5904\u7406\u8ba2\u5355\u72b6\u6001\u67e5\u8be2\u54cd\u5e94\u7ed3\u679c\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.QUERY_REFUND_BUILD_RESPONSE_PARAM_ERROR, request.toString());
        }
        return response;
    }

    @Override
    protected JSONObject buildCancelOrderRequestParams(CancelPaymentRequest request, JSONObject paymentConfig) {
        LOGGER.info(">>> \u6784\u5efa\u64a4\u9500\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570");
        try {
            return this.buildCommonParams(paymentConfig).put("outTradeNo", (Object)PaymentUtils.generateOrderId()).put("originalOutTradeNo", (Object)request.getOrderNo()).put("url", (Object)"/reverse");
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u64a4\u9500\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.CANCEL_ORDER_BUILD_REQUEST_PARAM_ERROR, request.toString());
        }
    }

    @Override
    protected CancelPaymentResponse processCancelOrderResponse(CancelPaymentResponse response, CancelPaymentRequest request, JSONObject resultJson) {
        LOGGER.info(">>> \u5904\u7406\u64a4\u9500\u8ba2\u5355\u54cd\u5e94\u7ed3\u679c");
        try {
            if ("00".equals(resultJson.optString("resultCode"))) {
                String refundStatus;
                response.setMchId(resultJson.optString("merchantNo"));
                response.setOrderNo(resultJson.optString("chnOrderId", resultJson.optString("chnOrderId")));
                PaymentStatus status = switch (refundStatus = resultJson.optString("refundStatus")) {
                    case "1" -> PaymentStatus.REFUND_PROCESSING;
                    case "2" -> PaymentStatus.CANCEL_ORDER_SUCCESS;
                    default -> PaymentStatus.REFUND_FAIL;
                };
                response.setCancelResult(status.getMessage());
            } else {
                LOGGER.info(">>> \u64a4\u9500\u8ba2\u5355\u94f6\u884c\u8fd4\u56de\u5931\u8d25\uff01");
                response.setCancelResult(PaymentStatus.CANCEL_ORDER_FAIL.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error(">>> \u5904\u7406\u64a4\u9500\u8ba2\u5355\u54cd\u5e94\u7ed3\u679c\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.CANCEL_ORDER_BUILD_RESPONSE_PARAM_ERROR, request.toString());
        }
        return response;
    }

    @Override
    protected JSONObject buildRefundOrderRequestParams(RefundPaymentRequest request, JSONObject paymentConfig) {
        LOGGER.info(">>> \u6784\u5efa\u8ba2\u5355\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570");
        try {
            return this.buildCommonParams(paymentConfig).put("mchtRefundNo", (Object)request.getRefundOrderNo()).put("outTradeNo", (Object)request.getOrderNo()).put("refundAmount", request.getAmount()).put("url", (Object)"/refund");
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u652f\u4ed8\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.REFUND_BUILD_REQUEST_PARAM_ERROR, request.toString());
        }
    }

    @Override
    protected RefundPaymentResponse processRefundOrderResponse(RefundPaymentResponse response, RefundPaymentRequest request, JSONObject resultJson) {
        LOGGER.info(">>> \u5904\u7406\u8ba2\u5355\u9000\u6b3e\u54cd\u5e94\u7ed3\u679c");
        try {
            if ("00".equals(resultJson.optString("resultCode"))) {
                response.setMchId(resultJson.optString("merchantNo"));
                response.setOrderNo(request.getOrderNo());
                response.setTransactionId(resultJson.optString("cposOrderId"));
                response.setRefundOrderNo(request.getRefundOrderNo());
                response.setRefundId(resultJson.optString("cposOrderId"));
                response.setRefundAmount(resultJson.optInt("transAmount"));
                response.setRefundResult(PaymentStatus.REFUND_REQUEST_SUCCESS.getMessage());
                response.setState(PaymentStatus.REFUND_REQUEST_SUCCESS);
            } else {
                LOGGER.info(">>> \u94f6\u884c\u8fd4\u56de\u8ba2\u5355\u9000\u6b3e\u4ea4\u6613\u5931\u8d25\uff01");
                response.setState(PaymentStatus.REFUND_REQUEST_FAIL);
                response.setMessage(resultJson.optString("resultMessage", PaymentStatus.REFUND_REQUEST_FAIL.getMessage()));
            }
        }
        catch (Exception e) {
            LOGGER.error(" \u6784\u5efa\u8ba2\u5355\u9000\u6b3e\u8fd4\u56de\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.REFUND_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.REFUND_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
        return response;
    }

    @Override
    protected JSONObject buildQueryRefundStatusRequestParams(QueryRefundStatusRequest request, JSONObject paymentConfig) {
        LOGGER.info(">>> \u6784\u5efa\u9000\u6b3e\u8ba2\u5355\u72b6\u6001\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570");
        try {
            return this.buildCommonParams(paymentConfig).put("outTradeNo", (Object)request.getOrderNo()).put("url", (Object)"/refundQuery");
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u9000\u6b3e\u8ba2\u5355\u72b6\u6001\u67e5\u6751\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.QUERY_REFUND_BUILD_REQUEST_PARAM_ERROR, request.toString());
        }
    }

    @Override
    protected QueryRefundStatusResponse processQueryRefundStatusResponse(QueryRefundStatusResponse response, QueryRefundStatusRequest request, JSONObject resultJson) {
        LOGGER.info(">>> \u5904\u7406\u9000\u6b3e\u8ba2\u5355\u72b6\u6001\u67e5\u8be2\u54cd\u5e94\u7ed3\u679c");
        try {
            if ("00".equals(resultJson.optString("resultCode"))) {
                response.setMchId(resultJson.optString("merchantNo"));
                response.setState(PaymentStatus.REFUND_SUCCESS);
                response.setOrderNo(request.getOrderNo());
                response.setTransactionId(resultJson.optString("cposOrderId"));
                response.setRefundAmount(resultJson.optInt("transAmount"));
                response.setRefundDateTime(DateTools.formatDateTime((String)resultJson.optString("paidTime", resultJson.optString("paidTime", DateTools.getNow((String)"yyyyMMddHHmmss")))));
            } else {
                LOGGER.info(">>> \u9000\u6b3e\u8ba2\u5355\u72b6\u6001\u67e5\u8be2\u94f6\u884c\u8fd4\u56de\u5931\u8d25\uff01");
                response.setState(PaymentStatus.PAY_FAIL);
            }
        }
        catch (Exception e) {
            LOGGER.error(">>> \u5904\u7406\u9000\u6b3e\u8ba2\u5355\u72b6\u6001\u67e5\u8be2\u54cd\u5e94\u7ed3\u679c\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.QUERY_REFUND_BUILD_RESPONSE_PARAM_ERROR, request.toString());
        }
        return response;
    }

    @Override
    protected void signRequest(JSONObject reqParams, JSONObject paymentConfig) {
        JSONObject filteredParams = new JSONObject();
        for (String key : reqParams.keySet()) {
            Iterator value = reqParams.get(key);
            if (value == null || "".equals(value.toString()) || "url".equals(key)) continue;
            filteredParams.put(key, value);
        }
        ArrayList keys = new ArrayList(filteredParams.keySet());
        Collections.sort(keys);
        StringBuilder beforeSigning = new StringBuilder();
        for (String key : keys) {
            if (beforeSigning.length() > 0) {
                beforeSigning.append("&");
            }
            beforeSigning.append(key).append("=").append(filteredParams.get(key));
        }
        LOGGER.info(">>> \u7b7e\u540d\u5b57\u7b26\u4e32\uff1a{}", (Object)beforeSigning);
        beforeSigning.append("&key=" + paymentConfig.getString("secretKey"));
        LOGGER.info(">>> \u5f85\u9a8c\u7b7e\u5b57\u7b26\u4e32\uff1a{}", (Object)beforeSigning);
        String sign = DigestUtils.md5Hex((String)String.valueOf(beforeSigning)).toUpperCase();
        LOGGER.info(">>> \u6700\u7ec8\u7b7e\u540d\u4e32: {}", (Object)sign);
        reqParams.put("sign", (Object)sign);
    }

    @Override
    protected JSONObject executePaymentRequest(JSONObject reqParams, JSONObject paymentConfig) {
        try {
            JSONObject headers = new JSONObject();
            LOGGER.info("\u8bf7\u6c42\u652f\u4ed8\u4e1a\u52a1, \u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)reqParams);
            String baseUrl = paymentConfig.getString("transactionurl");
            String bizUrl = reqParams.getString("url");
            String url = baseUrl + bizUrl;
            LOGGER.info(">>> \u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)url);
            reqParams.remove("url");
            headers.put("Content-Type", (Object)"application/xml");
            String response = RestTools.post((String)url, (String)String.valueOf(reqParams), (String)headers.toString());
            JSONObject jsonObject = JsonTools.convertToJson((String)response);
            LOGGER.info(">>> \u94f6\u884c\u54cd\u5e94\u539f\u59cb\u7ed3\u679c\uff1a" + String.valueOf(jsonObject));
            if ("\u65e0\u6548\u5546\u6237".equals(jsonObject.optString("resultMessage"))) {
                LOGGER.info(">>> \u65e0\u6548\u5546\u6237\uff0c\u91cd\u65b0\u7b7e\u5230");
                this.signInAndSaveBatchNo(paymentConfig);
            }
            return jsonObject;
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u652f\u4ed8\u4e1a\u52a1\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_ORDER_ERROR.getCode(), reqParams.toString(), PaymentStatus.PAY_ORDER_ERROR.getMessage());
        }
    }

    @Override
    protected boolean verifyResponseSign(JSONObject response, JSONObject paymentConfig) {
        try {
            String sign = response.optString("sign");
            if (sign == null) {
                return false;
            }
            response.remove("sign");
            this.signRequest(response, paymentConfig);
            String calculatedSign = response.optString("sign");
            LOGGER.info(">>> \u539f\u7b7e\u540d\u4e32\uff1a{}\uff0c\u65b0\u7b7e\u540d\u4e32\uff1a{}", (Object)sign, (Object)calculatedSign);
            return sign.equals(calculatedSign);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    protected JSONObject buildDownloadReconciliationFileRequestParams(DownloadReconciliationFileRequest request, JSONObject paymentConfig) {
        return null;
    }

    @Override
    protected DownloadReconciliationFileResponse processDownloadReconciliationFileResponse(DownloadReconciliationFileResponse response, DownloadReconciliationFileRequest request, JSONObject resultJson) {
        return null;
    }

    private String signInAndSaveBatchNo(JSONObject paymentConfig) {
        JSONObject signParams = new JSONObject().put("merchantNo", (Object)paymentConfig.optString("mchId")).put("terminalNo", (Object)paymentConfig.optString("posId"));
        this.signRequest(signParams, paymentConfig);
        String url = paymentConfig.getString("transactionurl") + paymentConfig.getString("signUrl");
        LOGGER.info(">>> \u7b7e\u5230\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)url, (Object)signParams);
        try {
            String response = RestTools.post((String)url, (JSONObject)signParams);
            LOGGER.info(">>> \u7b7e\u5230\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)response);
            JSONObject result = JsonTools.convertToJson((String)response);
            if ("00".equals(result.getString("resultCode"))) {
                String batchNo = result.getString("batchNo");
                String redisKey = this.generateBatchNoKey(paymentConfig);
                this.redisService.set(redisKey, (Object)batchNo, (Object)AHRcbPaymentHandlerImpl.secondsUntilTomorrow());
                return batchNo;
            }
            throw new RuntimeException(">>> \u7b7e\u5230\u5931\u8d25: " + result.getString("resultMessage"));
        }
        catch (Exception e) {
            throw new RuntimeException(">>> \u7b7e\u5230\u5f02\u5e38: {}" + e.getMessage());
        }
    }

    public String getBatchNo(JSONObject paymentConfig) {
        String redisKey = this.generateBatchNoKey(paymentConfig);
        try {
            LOGGER.info(">>> \u83b7\u53d6 [{}] \u6279\u6b21\u53f7:{}", (Object)redisKey, this.redisService.get(redisKey));
            String batchNo = (String)this.redisService.get(redisKey);
            if (!Objects.equals(batchNo, "null") || !batchNo.isEmpty()) {
                LOGGER.info(">>> \u4eceRedis\u83b7\u53d6key\u4e3a [{}] \u7684\u6279\u6b21\u53f7: {}", (Object)redisKey, (Object)batchNo);
                return batchNo;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.signInAndSaveBatchNo(paymentConfig);
    }

    private String generateKey(JSONObject paymentConfig, boolean hasTerminal) {
        String today = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        return hasTerminal ? String.format("payment_%s_%s_%s", paymentConfig.getString("mchId"), paymentConfig.getString("posId"), today) : String.format("payment_%s_%s", paymentConfig.getString("mchId"), today);
    }

    private String generateBatchNoKey(JSONObject paymentConfig) {
        return this.generateKey(paymentConfig, true);
    }

    private String generateTrackingNoKey(JSONObject paymentConfig) {
        return this.generateKey(paymentConfig, false);
    }

    public static long secondsUntilTomorrow() {
        Instant now = Instant.now();
        ZoneId zone = ZoneId.systemDefault();
        LocalDate today = LocalDate.ofInstant(now, zone);
        LocalDate tomorrow = today.plusDays(1L);
        ZonedDateTime tomorrowMidnight = tomorrow.atStartOfDay(zone);
        return tomorrowMidnight.toEpochSecond() - now.getEpochSecond();
    }
}

