package com.af.v4.system.common.payment.dto;

import org.json.JSONObject;


/**
 * 下载对账文件请求参数
 * @author zqm
 */
public class DownloadReconciliationFileRequest {

    /**
     * 银行名称
     */
    private final String bankName;
    /**
     * 分公司名称
     */
    private final String orgName;

    /**
     * 下载路径
     */
    private String downloadPath;
    /**
     * 交易时间（yyyyMMdd）
     */
    private final String tradeTime;


    public String getBankName() {
        return bankName;
    }

    public String getOrgName() {
        return orgName;
    }

    public String getDownloadPath() {
        return downloadPath;
    }

    public String getTradeTime() {
        return tradeTime;
    }

    public String setDownloadPath(String downloadPath) {
        this.downloadPath = downloadPath;
        return downloadPath;
    }



    // 私有构造函数，防止直接实例化
    private DownloadReconciliationFileRequest(Builder builder) {
        this.downloadPath = builder.downloadPath;
        this.tradeTime = builder.tradeTime;
        this.bankName = builder.bankName;
        this.orgName = builder.orgName;
    }

    // Builder 静态内部类
    public static class Builder {
        private String downloadPath;
        private String tradeTime;
        private String bankName;
        private String orgName;

        public Builder() {
        }
        /**
         * 静态工厂方法，通过 JSONObject 构造 DownloadReconciliationFileRequest
         *
         * @param jsonObject 参数
         * @return 构造器
         */
        public static Builder fromJsonObject(JSONObject jsonObject) {
            Builder builder = new Builder();
            if (jsonObject == null) {
                return builder;
            }

            if (jsonObject.has("downloadPath")) {
                builder.downloadPath(jsonObject.getString("downloadPath"));
            }
            if (jsonObject.has("tradeTime")) {
                builder.tradeTime(jsonObject.getString("tradeTime"));
            }
            if (jsonObject.has("bankName")) {
                builder.bankName(jsonObject.getString("bankName"));
            }
            if (jsonObject.has("orgName")) {
                builder.orgName(jsonObject.getString("orgName"));
            }
            return builder;
        }




        public Builder orgName(String orgName) {
            this.orgName = orgName;
            return this;
        }

        public Builder bankName(String bankName) {
            this.bankName = bankName;
            return this;
        }

        public Builder tradeTime(String tradeTime) {
            this.tradeTime = tradeTime;
            return this;
        }

        public Builder downloadPath(String downloadPath) {
            this.downloadPath = downloadPath;
            return this;
        }


        public DownloadReconciliationFileRequest build() {
            return new DownloadReconciliationFileRequest(this);
        }
    }
}
