/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.handler.impl.ceb;

import com.af.v4.system.common.payment.annotation.PaymentHandlerConfig;
import com.af.v4.system.common.payment.dto.CancelPaymentRequest;
import com.af.v4.system.common.payment.dto.CancelPaymentResponse;
import com.af.v4.system.common.payment.dto.DownloadReconciliationFileRequest;
import com.af.v4.system.common.payment.dto.DownloadReconciliationFileResponse;
import com.af.v4.system.common.payment.dto.PaymentOrderRequest;
import com.af.v4.system.common.payment.dto.PaymentOrderResponse;
import com.af.v4.system.common.payment.dto.QueryPaymentStatusRequest;
import com.af.v4.system.common.payment.dto.QueryPaymentStatusResponse;
import com.af.v4.system.common.payment.dto.QueryRefundStatusRequest;
import com.af.v4.system.common.payment.dto.QueryRefundStatusResponse;
import com.af.v4.system.common.payment.dto.RefundPaymentRequest;
import com.af.v4.system.common.payment.dto.RefundPaymentResponse;
import com.af.v4.system.common.payment.enums.BankName;
import com.af.v4.system.common.payment.enums.IntegrationType;
import com.af.v4.system.common.payment.enums.PaymentStatus;
import com.af.v4.system.common.payment.exceptions.PaymentException;
import com.af.v4.system.common.payment.handler.impl.AbstractPaymentHandler;
import com.af.v4.system.common.payment.utils.SignUtils;
import com.af.v4.system.common.plugins.date.DateTools;
import com.af.v4.system.common.plugins.http.RestTools;
import com.af.v4.system.common.plugins.json.JsonTools;
import java.util.Date;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@PaymentHandlerConfig(bankName=BankName.CEB, integrationTypes={IntegrationType.SCAN_DEVICE})
public class CEBAggregatePaymentHandler
extends AbstractPaymentHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CEBAggregatePaymentHandler.class);

    @Override
    protected JSONObject buildPayOrderRequestParams(PaymentOrderRequest request, JSONObject paymentConfig) {
        try {
            JSONObject reqParams = this.getRequestHeard(paymentConfig);
            reqParams.put("service", (Object)"unified.trade.micropay");
            reqParams.put("out_trade_no", (Object)request.getOrderNo());
            reqParams.put("body", (Object)request.getDescription());
            reqParams.put("total_fee", request.getAmount());
            reqParams.put("mch_create_ip", (Object)paymentConfig.getString("mchServiceIP"));
            reqParams.put("auth_code", (Object)request.getAuthCode());
            reqParams.put("version", (Object)"2.0");
            JSONObject terminalInfo = new JSONObject();
            terminalInfo.put("terminal_type", (Object)"11");
            terminalInfo.put("app_version", (Object)"1.000000");
            reqParams.put("terminal_info", (Object)terminalInfo.toString());
            return reqParams;
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u652f\u4ed8\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected PaymentOrderResponse processPayOrderResponse(PaymentOrderResponse response, PaymentOrderRequest request, JSONObject resultJson, JSONObject paymentConfig) {
        LOGGER.info("\u5f00\u59cb\u6784\u5efa\u652f\u4ed8\u8ba2\u5355\u8fd4\u56de\u53c2\u6570!");
        try {
            boolean neddQuery = false;
            String payState = "\u672a\u652f\u4ed8";
            if ("0".equals(resultJson.optString("status"))) {
                response.setCode(PaymentStatus.PAY_SUCCESS.getCode());
                response.setMessage(PaymentStatus.PAY_SUCCESS.getMessage());
                response.setOrderNo(resultJson.optString("out_trade_no"));
                response.setMchId(resultJson.optString("mch_id"));
                response.setTransactionId(resultJson.optString("transaction_id"));
                response.setAllowRefunds(paymentConfig.optString("allowRefunds"));
                response.setAllowCancel(paymentConfig.optString("allowCancel"));
                if (resultJson.has("total_fee")) {
                    response.setAmount(resultJson.optInt("total_fee"));
                }
                if ("0".equals(resultJson.optString("result_code"))) {
                    if ("0".equals(resultJson.optString("pay_result"))) {
                        payState = "\u652f\u4ed8\u6210\u529f";
                    } else if (!"0".equals(resultJson.optString("pay_result")) && "Y".equals(resultJson.optString("need_query"))) {
                        neddQuery = true;
                    }
                    if (resultJson.has("time_end")) {
                        response.setPaySuccessDate(DateTools.formatDateTime((String)resultJson.optString("time_end")));
                    }
                } else if ("1".equals(resultJson.optString("result_code")) && "04021_1211037".equals(resultJson.optString("code"))) {
                    neddQuery = true;
                    if (!"".equals(resultJson.optString("time_end"))) {
                        response.setPaySuccessDate(DateTools.formatDateTime((String)resultJson.optString("time_end")));
                    } else {
                        response.setPaySuccessDate(DateTools.getNow2());
                    }
                }
                response.setNeedQuery(neddQuery);
                response.setPayResult(payState);
            } else {
                LOGGER.info("\u672c\u6b21\u652f\u4ed8\u8ba2\u5355\u4ea4\u6613\u901a\u4fe1\u5931\u8d25\uff01");
                response.setCode(PaymentStatus.COMMUNICATION_FAIL.getCode());
                response.setMessage(PaymentStatus.COMMUNICATION_FAIL.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u652f\u4ed8\u8ba2\u5355\u8fd4\u56de\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
        return response;
    }

    @Override
    protected JSONObject buildQueryPaymentStatusRequestParams(QueryPaymentStatusRequest request, JSONObject paymentConfig) {
        try {
            JSONObject reqParams = this.getRequestHeard(paymentConfig);
            reqParams.put("service", (Object)"unified.trade.query");
            reqParams.put("out_trade_no", (Object)request.getOrderNo());
            reqParams.put("transaction_id", (Object)request.getTransactionId());
            return reqParams;
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u67e5\u8be2\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.QUERY_ORDER_BUILD_REQUEST_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.QUERY_ORDER_BUILD_REQUEST_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected QueryPaymentStatusResponse processQueryPaymentStatusResponse(QueryPaymentStatusResponse response, QueryPaymentStatusRequest request, JSONObject resultJson) {
        LOGGER.info("\u5f00\u59cb\u6784\u5efa\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u8fd4\u56de\u53c2\u6570!");
        try {
            if ("0".equals(resultJson.optString("status"))) {
                if ("0".equals(resultJson.optString("result_code"))) {
                    response.setCode(PaymentStatus.PAY_SUCCESS.getCode());
                    response.setMessage(PaymentStatus.PAY_SUCCESS.getMessage());
                    response.setMchId(resultJson.optString("mch_id"));
                    response.setOrderNo(resultJson.optString("out_trade_no"));
                    response.setTransactionId(resultJson.optString("transaction_id"));
                    response.setAmount(resultJson.optInt("total_fee"));
                    if ("SUCCESS".equals(resultJson.optString("trade_state"))) {
                        response.setPaymentStatus(PaymentStatus.SUCCESS_FOR_PAYMENT.getMessage());
                        response.setCode(PaymentStatus.SUCCESS_FOR_PAYMENT.getCode());
                        response.setMessage(PaymentStatus.SUCCESS_FOR_PAYMENT.getMessage());
                    } else if ("REFUND".equals(resultJson.optString("trade_state"))) {
                        response.setPaymentStatus(PaymentStatus.REFUND_FOR_PAYMENT.getMessage());
                        response.setCode(PaymentStatus.REFUND_FOR_PAYMENT.getCode());
                        response.setMessage(PaymentStatus.REFUND_FOR_PAYMENT.getMessage());
                    } else if ("NOTPAY".equals(resultJson.optString("trade_state"))) {
                        response.setPaymentStatus(PaymentStatus.NOT_FOR_PAYMENT.getMessage());
                        response.setCode(PaymentStatus.NOT_FOR_PAYMENT.getCode());
                        response.setMessage(PaymentStatus.NOT_FOR_PAYMENT.getMessage());
                    } else if ("REVOKED".equals(resultJson.optString("trade_state")) || "REVERSE".equals(resultJson.optString("trade_state"))) {
                        response.setPaymentStatus(PaymentStatus.CANCEL_FOR_PAYMENT.getMessage());
                        response.setCode(PaymentStatus.CANCEL_FOR_PAYMENT.getCode());
                        response.setMessage(PaymentStatus.CANCEL_FOR_PAYMENT.getMessage());
                    } else if ("USERPAYING".equals(resultJson.optString("trade_state"))) {
                        response.setPaymentStatus(PaymentStatus.PAYMENT_IN_PROGRESS.getMessage());
                        response.setCode(PaymentStatus.PAYMENT_IN_PROGRESS.getCode());
                        response.setMessage(PaymentStatus.PAYMENT_IN_PROGRESS.getMessage());
                    } else if ("PAYERROR".equals(resultJson.optString("trade_state"))) {
                        response.setPaymentStatus(PaymentStatus.FAIL_FOR_PAYMENT.getMessage());
                        response.setCode(PaymentStatus.FAIL_FOR_PAYMENT.getCode());
                        response.setMessage(PaymentStatus.FAIL_FOR_PAYMENT.getMessage());
                    }
                    if (!"".equals(resultJson.optString("time_end"))) {
                        response.setPaySuccessDate(DateTools.formatDateTime((String)resultJson.optString("time_end")));
                    } else {
                        response.setPaySuccessDate(DateTools.getNow2());
                    }
                } else {
                    response.setCode(PaymentStatus.PAY_FAIL.getCode());
                    response.setMessage(PaymentStatus.PAY_FAIL.getMessage());
                }
            } else {
                LOGGER.info("\u672c\u6b21\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u4ea4\u6613\u901a\u4fe1\u5931\u8d25\uff01");
                response.setCode(PaymentStatus.COMMUNICATION_FAIL.getCode());
                response.setMessage(PaymentStatus.COMMUNICATION_FAIL.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u8fd4\u56de\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.QUERY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.QUERY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
        return response;
    }

    @Override
    protected JSONObject buildCancelOrderRequestParams(CancelPaymentRequest request, JSONObject paymentConfig) {
        try {
            JSONObject reqParams = this.getRequestHeard(paymentConfig);
            reqParams.put("service", (Object)"unified.micropay.reverse");
            reqParams.put("out_trade_no", (Object)request.getOrderNo());
            return reqParams;
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u8ba2\u5355\u64a4\u9500\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.CANCEL_ORDER_BUILD_REQUEST_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.CANCEL_ORDER_BUILD_REQUEST_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected CancelPaymentResponse processCancelOrderResponse(CancelPaymentResponse response, CancelPaymentRequest request, JSONObject resultJson) {
        LOGGER.info("\u5f00\u59cb\u6784\u5efa\u64a4\u9500\u8ba2\u5355\u8fd4\u56de\u53c2\u6570!");
        try {
            if ("0".equals(resultJson.optString("status"))) {
                if ("0".equals(resultJson.optString("result_code"))) {
                    response.setCode(PaymentStatus.CANCEL_ORDER_SUCCESS.getCode());
                    response.setMessage(PaymentStatus.CANCEL_ORDER_SUCCESS.getMessage());
                    response.setMchId(resultJson.optString("mch_id"));
                    response.setOrderNo(resultJson.optString("out_trade_no"));
                    response.setCancelResult(resultJson.optString("transaction_id"));
                    String cancelState = "\u64a4\u9500\u6210\u529f";
                    if (!"0".equals(resultJson.optString("result_code"))) {
                        cancelState = "\u64a4\u9500\u5931\u8d25";
                        response.setCode(PaymentStatus.CANCEL_ORDER_FAIL.getCode());
                        response.setMessage(PaymentStatus.CANCEL_ORDER_FAIL.getMessage());
                    }
                    response.setCancelResult(cancelState);
                } else {
                    response.setCode(PaymentStatus.PAY_FAIL.getCode());
                    response.setMessage(PaymentStatus.PAY_FAIL.getMessage());
                }
            } else {
                LOGGER.info("\u672c\u6b21\u64a4\u9500\u8ba2\u5355\u4ea4\u6613\u901a\u4fe1\u5931\u8d25\uff01");
                response.setCode(PaymentStatus.COMMUNICATION_FAIL.getCode());
                response.setMessage(PaymentStatus.COMMUNICATION_FAIL.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u64a4\u9500\u8ba2\u5355\u8fd4\u56de\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.CANCEL_ORDER_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.CANCEL_ORDER_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
        return response;
    }

    @Override
    protected JSONObject buildRefundOrderRequestParams(RefundPaymentRequest request, JSONObject paymentConfig) {
        try {
            JSONObject reqParams = this.getRequestHeard(paymentConfig);
            reqParams.put("service", (Object)"unified.trade.refund");
            reqParams.put("out_trade_no", (Object)request.getOrderNo());
            reqParams.put("out_refund_no", (Object)request.getRefundOrderNo());
            reqParams.put("total_fee", request.getAmount());
            reqParams.put("refund_fee", request.getRefundAmount());
            reqParams.put("op_user_id", (Object)reqParams.getString("mch_id"));
            return reqParams;
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u8ba2\u5355\u64a4\u9500\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.REFUND_BUILD_REQUEST_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.REFUND_BUILD_REQUEST_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected RefundPaymentResponse processRefundOrderResponse(RefundPaymentResponse response, RefundPaymentRequest request, JSONObject resultJson) {
        LOGGER.info("\u5f00\u59cb\u6784\u5efa\u8ba2\u5355\u9000\u6b3e\u8fd4\u56de\u53c2\u6570!");
        try {
            if ("0".equals(resultJson.optString("status"))) {
                if ("0".equals(resultJson.optString("result_code"))) {
                    response.setCode(PaymentStatus.REFUND_SUCCESS.getCode());
                    response.setMessage(PaymentStatus.REFUND_SUCCESS.getMessage());
                    response.setMchId(resultJson.optString("mch_id"));
                    response.setOrderNo(resultJson.optString("out_trade_no"));
                    response.setTransactionId(resultJson.optString("transaction_id"));
                    response.setRefundOrderNo(resultJson.optString("out_refund_no_$0"));
                    response.setRefundId(resultJson.optString("out_refund_id_$0"));
                    response.setRefundAmount(resultJson.optInt("refund_fee_$0"));
                    if ("SUCCESS".equals(resultJson.optString("refund_status_$n0"))) {
                        response.setRefundResult(PaymentStatus.REFUND_SUCCESS.getMessage());
                        response.setCode(PaymentStatus.REFUND_SUCCESS.getCode());
                        response.setMessage(PaymentStatus.REFUND_SUCCESS.getMessage());
                    } else if ("FAIL".equals(resultJson.optString("refund_status_$n0"))) {
                        response.setRefundResult(PaymentStatus.REFUND_FAIL.getMessage());
                        response.setCode(PaymentStatus.REFUND_FAIL.getCode());
                        response.setMessage(PaymentStatus.REFUND_FAIL.getMessage());
                    } else if ("PROCESSING".equals(resultJson.optString("refund_status_$n0"))) {
                        response.setRefundResult(PaymentStatus.REFUND_PROCESSING.getMessage());
                        response.setCode(PaymentStatus.REFUND_PROCESSING.getCode());
                        response.setMessage(PaymentStatus.REFUND_PROCESSING.getMessage());
                    } else if ("CHANGE".equals(resultJson.optString("refund_status_$n0"))) {
                        response.setRefundResult(PaymentStatus.REFUND_CHANGE.getMessage());
                        response.setCode(PaymentStatus.REFUND_CHANGE.getCode());
                        response.setMessage(PaymentStatus.REFUND_CHANGE.getMessage());
                    }
                } else {
                    response.setCode(PaymentStatus.PAY_FAIL.getCode());
                    response.setMessage(PaymentStatus.PAY_FAIL.getMessage());
                }
            } else {
                LOGGER.info("\u672c\u6b21\u8ba2\u5355\u9000\u6b3e\u4ea4\u6613\u901a\u4fe1\u5931\u8d25\uff01");
                response.setCode(PaymentStatus.COMMUNICATION_FAIL.getCode());
                response.setMessage(PaymentStatus.COMMUNICATION_FAIL.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u8ba2\u5355\u9000\u6b3e\u8fd4\u56de\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.REFUND_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.REFUND_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
        return response;
    }

    @Override
    protected JSONObject buildQueryRefundStatusRequestParams(QueryRefundStatusRequest request, JSONObject paymentConfig) {
        try {
            JSONObject reqParams = this.getRequestHeard(paymentConfig);
            reqParams.put("service", (Object)"unified.trade.refundquery");
            reqParams.put("out_trade_no", (Object)request.getOrderNo());
            reqParams.put("refund_id", (Object)request.getRefundId());
            return reqParams;
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u67e5\u8be2\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.QUERY_REFUND_BUILD_REQUEST_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.REFUND_BUILD_REQUEST_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected QueryRefundStatusResponse processQueryRefundStatusResponse(QueryRefundStatusResponse response, QueryRefundStatusRequest request, JSONObject resultJson) {
        LOGGER.info("\u5f00\u59cb\u6784\u5efa\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u8fd4\u56de\u53c2\u6570!");
        try {
            if ("0".equals(resultJson.optString("status"))) {
                if ("0".equals(resultJson.optString("result_code"))) {
                    response.setCode(PaymentStatus.REFUND_SUCCESS.getCode());
                    response.setMessage(PaymentStatus.REFUND_SUCCESS.getMessage());
                    response.setMchId(resultJson.optString("mch_id"));
                    response.setOrderNo(resultJson.optString("out_trade_no"));
                    response.setRefundId(resultJson.optString("out_refund_id_$0"));
                    response.setTransactionId(resultJson.optString("transaction_id"));
                    response.setRefundOrderNo(resultJson.optString("out_refund_no_$0"));
                    response.setRefundAmount(resultJson.optInt("refund_fee_$0"));
                    response.setRefundDateTime(resultJson.optString("refund_time_$0"));
                    if ("SUCCESS".equals(resultJson.optString("refund_status_$n0"))) {
                        response.setRefundResult(PaymentStatus.REFUND_SUCCESS.getMessage());
                        response.setCode(PaymentStatus.REFUND_SUCCESS.getCode());
                        response.setMessage(PaymentStatus.REFUND_SUCCESS.getMessage());
                    } else if ("FAIL".equals(resultJson.optString("refund_status_$n0"))) {
                        response.setRefundResult(PaymentStatus.REFUND_FAIL.getMessage());
                        response.setCode(PaymentStatus.REFUND_FAIL.getCode());
                        response.setMessage(PaymentStatus.REFUND_FAIL.getMessage());
                    } else if ("PROCESSING".equals(resultJson.optString("refund_status_$n0"))) {
                        response.setRefundResult(PaymentStatus.REFUND_PROCESSING.getMessage());
                        response.setCode(PaymentStatus.REFUND_PROCESSING.getCode());
                        response.setMessage(PaymentStatus.REFUND_PROCESSING.getMessage());
                    } else if ("CHANGE".equals(resultJson.optString("refund_status_$n0"))) {
                        response.setRefundResult(PaymentStatus.REFUND_CHANGE.getMessage());
                        response.setCode(PaymentStatus.REFUND_CHANGE.getCode());
                        response.setMessage(PaymentStatus.REFUND_CHANGE.getMessage());
                    }
                } else {
                    response.setCode(PaymentStatus.PAY_FAIL.getCode());
                    response.setMessage(PaymentStatus.PAY_FAIL.getMessage());
                }
            } else {
                LOGGER.info("\u672c\u6b21\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u4ea4\u6613\u901a\u4fe1\u5931\u8d25\uff01");
                response.setCode(PaymentStatus.COMMUNICATION_FAIL.getCode());
                response.setMessage(PaymentStatus.COMMUNICATION_FAIL.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u8fd4\u56de\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.REFUND_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.REFUND_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
        return response;
    }

    @Override
    protected void signRequest(JSONObject reqParams, JSONObject paymentConfig) {
        try {
            SignUtils.signRequestParams(reqParams, "RSA_1_256", "sign", paymentConfig.getString("privateKey"));
        }
        catch (Exception e) {
            LOGGER.error("\u7b7e\u540d\u5931\u8d25", (Throwable)e);
            throw new PaymentException(PaymentStatus.SIGN_FAIL.getCode(), reqParams.toString(), PaymentStatus.SIGN_FAIL.getMessage());
        }
    }

    @Override
    protected JSONObject executePaymentRequest(JSONObject reqParams, JSONObject paymentConfig) {
        try {
            JSONObject headers = new JSONObject();
            String formattedRequest = JsonTools.jsonConvertToXml((JSONObject)reqParams);
            LOGGER.info("\u8bf7\u6c42\u652f\u4ed8\u63a5\u53e3, \u8bf7\u6c42\u62a5\u6587={}", (Object)formattedRequest);
            headers.put("Content-Type", (Object)"application/xml");
            String response = RestTools.post((String)paymentConfig.getString("transactionurl"), (String)formattedRequest, (String)headers.toString());
            return JsonTools.xmlConvertToJson((String)response);
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u652f\u4ed8\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_ORDER_ERROR.getCode(), reqParams.toString(), PaymentStatus.PAY_ORDER_ERROR.getMessage());
        }
    }

    @Override
    protected boolean verifyResponseSign(JSONObject response, JSONObject paymentConfig) {
        try {
            return SignUtils.verifySign(response, response.getString("sign_type"), response.getString("sign"), paymentConfig.getString("publicKey"));
        }
        catch (Exception e) {
            LOGGER.error("\u9a8c\u7b7e\u5931\u8d25\uff01", (Throwable)e);
            throw new PaymentException(PaymentStatus.VERIFY_SIGN_FAIL.getCode(), "{}", PaymentStatus.VERIFY_SIGN_FAIL.getMessage());
        }
    }

    @Override
    protected JSONObject buildDownloadReconciliationFileRequestParams(DownloadReconciliationFileRequest request, JSONObject paymentConfig) {
        return null;
    }

    @Override
    protected DownloadReconciliationFileResponse processDownloadReconciliationFileResponse(DownloadReconciliationFileResponse response, DownloadReconciliationFileRequest request, JSONObject resultJson) {
        return null;
    }

    private JSONObject getRequestHeard(JSONObject paymentConfig) {
        JSONObject reqParams = new JSONObject();
        reqParams.put("sign_type", (Object)"RSA_1_256");
        reqParams.put("mch_id", (Object)paymentConfig.getString("mchId"));
        reqParams.put("nonce_str", (Object)String.valueOf(new Date().getTime()));
        return reqParams;
    }
}

