package com.af.v4.system.common.payment.dto;

import org.json.JSONObject;

/**
 * 查询退款状态请求参数
 *
 * @author llzh
 * @DateTime 2024/12/30 14:06
 */
public class QueryRefundStatusRequest {
    /**
     * 商户订单号
     */
    private final String orderNo;
    /**
     * 平台退款单号
     */
    private final String refundId;
    /**
     * 银行名称
     */
    private final String bankName;
    /**
     * 分公司名称
     */
    private final String orgName;
    /**
     * 自定义参数
     */
    public JSONObject getCustomParams;

    // 私有构造函数，防止直接实例化
    private QueryRefundStatusRequest(Builder builder) {
        this.orderNo = builder.orderNo;
        this.refundId = builder.refundId;
        this.bankName = builder.bankName;
        this.orgName = builder.orgName;
        this.getCustomParams = builder.customParams;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public String getRefundId() {
        return refundId;
    }

    public String getBankName() {
        return bankName;
    }

    public String getOrgName() {
        return orgName;
    }

    public JSONObject getCustomParams() {
        return getCustomParams;
    }




    // Builder 静态内部类
    public static class Builder {
        private String orderNo;
        private String refundId;
        private String bankName;
        private String orgName;
        private JSONObject customParams;
        public Builder() {
        }

        public static Builder fromJsonObject(JSONObject jsonObject) {
            Builder builder = new Builder();
            if (jsonObject == null) {
                return builder;
            }
            if (jsonObject.has("orderNo")) {
                builder.orderNo(jsonObject.getString("orderNo"));
            }
            if (jsonObject.has("refundId")) {
                builder.refundId(jsonObject.getString("refundId"));
            }
            if (jsonObject.has("bankName")) {
                builder.bankName(jsonObject.getString("bankName"));
            }
            if (jsonObject.has("orgName")) {
                builder.orgName(jsonObject.getString("orgName"));
            }
            if (jsonObject.has("customParams")) {
                builder.customParams(jsonObject.getJSONObject("customParams"));
            }
            return builder;

        }



        public Builder customParams(JSONObject customParams) {
            this.customParams = customParams;
            return this;
        }

        public Builder orderNo(String orderNo) {
            this.orderNo = orderNo;
            return this;
        }

        public Builder refundId(String refundId) {
            this.refundId = refundId;
            return this;
        }

        public Builder orgName(String orgName) {
            this.orgName = orgName;
            return this;
        }

        public Builder bankName(String bankName) {
            this.bankName = bankName;
            return this;
        }

        public QueryRefundStatusRequest build() {
            return new QueryRefundStatusRequest(this);
        }
    }
}
