/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.handler.impl.rcb;

import com.af.v4.system.common.payment.annotation.PaymentHandlerConfig;
import com.af.v4.system.common.payment.dto.CancelPaymentRequest;
import com.af.v4.system.common.payment.dto.CancelPaymentResponse;
import com.af.v4.system.common.payment.dto.DownloadReconciliationFileRequest;
import com.af.v4.system.common.payment.dto.DownloadReconciliationFileResponse;
import com.af.v4.system.common.payment.dto.PaymentOrderRequest;
import com.af.v4.system.common.payment.dto.PaymentOrderResponse;
import com.af.v4.system.common.payment.dto.QueryPaymentStatusRequest;
import com.af.v4.system.common.payment.dto.QueryPaymentStatusResponse;
import com.af.v4.system.common.payment.dto.QueryRefundStatusRequest;
import com.af.v4.system.common.payment.dto.QueryRefundStatusResponse;
import com.af.v4.system.common.payment.dto.RefundPaymentRequest;
import com.af.v4.system.common.payment.dto.RefundPaymentResponse;
import com.af.v4.system.common.payment.enums.BankName;
import com.af.v4.system.common.payment.enums.IntegrationType;
import com.af.v4.system.common.payment.enums.PaymentStatus;
import com.af.v4.system.common.payment.exceptions.PaymentException;
import com.af.v4.system.common.payment.handler.impl.AbstractPaymentHandler;
import com.af.v4.system.common.payment.utils.MD5Utils;
import com.af.v4.system.common.payment.utils.PaymentUtils;
import com.af.v4.system.common.plugins.date.DateTools;
import com.af.v4.system.common.plugins.http.RestTools;
import com.af.v4.system.common.plugins.json.JsonTools;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@PaymentHandlerConfig(bankName=BankName.HN_RCB, integrationTypes={IntegrationType.SCAN_DEVICE})
public class HNRCBAbstractPaymentHandlerImpl
extends AbstractPaymentHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HNRCBAbstractPaymentHandlerImpl.class);
    private static final String SUCCESS_CODE = "00";

    @Override
    protected JSONObject buildPayOrderRequestParams(PaymentOrderRequest request, JSONObject paymentConfig) {
        LOGGER.info(">>> \u6784\u5efa\u652f\u4ed8\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570 > ");
        try {
            JSONObject reqParams = this.getRequestHeard(paymentConfig);
            reqParams.put("outTradeNo", (Object)request.getOrderNo());
            String amountYuan = BigDecimal.valueOf(request.getAmount()).divide(BigDecimal.valueOf(100L), 2, RoundingMode.DOWN).toPlainString();
            reqParams.put("amount", (Object)amountYuan);
            reqParams.put("realAmount", (Object)amountYuan);
            reqParams.put("authCode", (Object)request.getAuthCode());
            reqParams.put("terminal_ip", (Object)"127.0.0.1");
            reqParams.put("terminalType", (Object)"WEB");
            reqParams.put("_action", (Object)"PAY");
            return reqParams;
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u652f\u4ed8\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected PaymentOrderResponse processPayOrderResponse(PaymentOrderResponse response, PaymentOrderRequest request, JSONObject resultJson, JSONObject paymentConfig) {
        LOGGER.info(">>> \u5904\u7406\u652f\u4ed8\u8ba2\u5355\u54cd\u5e94\u7ed3\u679c > ");
        try {
            boolean needQuery = true;
            if (SUCCESS_CODE.equals(resultJson.optString("code"))) {
                String payState;
                response.setState(PaymentStatus.PAY_SUCCESS);
                response.setOrderNo(resultJson.getJSONObject("data").optString("outTradeNo"));
                if ("P".equals(resultJson.getJSONObject("data").optString("payStatus"))) {
                    payState = "\u4ea4\u6613\u6210\u529f";
                    needQuery = false;
                } else {
                    payState = resultJson.optString("err_msg", "\u4ea4\u6613\u5931\u8d25");
                }
                response.setNeedQuery(needQuery);
                response.setPayResult(payState);
            } else {
                LOGGER.info("\u672c\u6b21\u652f\u4ed8\u8ba2\u5355\u4ea4\u6613\u901a\u4fe1\u5931\u8d25\uff01");
                response.setCode(PaymentStatus.COMMUNICATION_FAIL.getCode());
                response.setMessage(PaymentStatus.COMMUNICATION_FAIL.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u652f\u4ed8\u8ba2\u5355\u8fd4\u56de\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
        return response;
    }

    @Override
    protected JSONObject buildQueryPaymentStatusRequestParams(QueryPaymentStatusRequest request, JSONObject paymentConfig) {
        LOGGER.info(">>> \u6784\u5efa\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u8bf7\u6c42\u53c2\u6570 > ");
        try {
            JSONObject reqParams = this.getRequestHeard(paymentConfig);
            reqParams.put("outTradeNo", (Object)request.getOrderNo());
            reqParams.put("_action", (Object)"QUERY");
            return reqParams;
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u67e5\u8be2\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.QUERY_ORDER_BUILD_REQUEST_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.QUERY_ORDER_BUILD_REQUEST_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected QueryPaymentStatusResponse processQueryPaymentStatusResponse(QueryPaymentStatusResponse response, QueryPaymentStatusRequest request, JSONObject resultJson) {
        LOGGER.info("\u5904\u7406\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u54cd\u5e94\u7ed3\u679c > ");
        try {
            if (SUCCESS_CODE.equals(resultJson.optString("code"))) {
                if ("P".equals(resultJson.getJSONObject("data").optString("payStatus"))) {
                    String tradeState;
                    response.setTransactionId(resultJson.getJSONObject("data").optString("outChannelNo"));
                    response.setOrderNo(resultJson.getJSONObject("data").optString("outTradeNo"));
                    response.setAmount(resultJson.getJSONObject("data").getInt("realAmount") * 100);
                    PaymentStatus status = switch (tradeState = resultJson.getJSONObject("data").optString("payStatus")) {
                        case "P" -> {
                            response.setPaymentStatus(PaymentStatus.SUCCESS_FOR_PAYMENT.getMessage());
                            response.setState(PaymentStatus.SUCCESS_FOR_PAYMENT);
                            String transTime = resultJson.getJSONObject("data").optString("transTime");
                            if (transTime != null && !transTime.isEmpty()) {
                                response.setPaySuccessDate(DateTools.formatDateTime((String)transTime));
                            }
                            yield PaymentStatus.SUCCESS_FOR_PAYMENT;
                        }
                        case "O" -> {
                            response.setState(PaymentStatus.NOT_FOR_PAYMENT);
                            yield PaymentStatus.NOT_FOR_PAYMENT;
                        }
                        case "I" -> {
                            response.setState(PaymentStatus.PAYMENT_IN_PROGRESS);
                            yield PaymentStatus.PAYMENT_IN_PROGRESS;
                        }
                        case "F" -> {
                            response.setState(PaymentStatus.FAIL_FOR_PAYMENT);
                            yield PaymentStatus.FAIL_FOR_PAYMENT;
                        }
                        case "T" -> {
                            response.setState(PaymentStatus.PAY_ORDER_TIMEOUT);
                            yield PaymentStatus.PAY_ORDER_TIMEOUT;
                        }
                        case "R" -> {
                            response.setState(PaymentStatus.REFUND_FOR_PAYMENT);
                            yield PaymentStatus.REFUND_FOR_PAYMENT;
                        }
                        case "C" -> {
                            response.setState(PaymentStatus.ORDER_BEEN_CLOSED);
                            yield PaymentStatus.ORDER_BEEN_CLOSED;
                        }
                        case "N" -> {
                            response.setState(PaymentStatus.CANCEL_FOR_PAYMENT);
                            yield PaymentStatus.CANCEL_FOR_PAYMENT;
                        }
                        default -> {
                            response.setState(PaymentStatus.QUERY_ORDER_FAIL);
                            yield PaymentStatus.QUERY_ORDER_FAIL;
                        }
                    };
                    response.setPaymentStatus(status.getMessage());
                    response.setState(status);
                    String transTime = resultJson.getJSONObject("data").optString("transTime");
                    if (transTime != null && !transTime.isEmpty()) {
                        response.setPaySuccessDate(DateTools.formatDateTime((String)transTime));
                    }
                } else {
                    response.setState(PaymentStatus.PAY_FAIL);
                }
            } else {
                LOGGER.info("\u672c\u6b21\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u4ea4\u6613\u901a\u4fe1\u5931\u8d25\uff01");
                response.setCode(PaymentStatus.COMMUNICATION_FAIL.getCode());
                response.setMessage(PaymentStatus.COMMUNICATION_FAIL.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u8fd4\u56de\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.QUERY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.QUERY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
        return response;
    }

    @Override
    protected JSONObject buildCancelOrderRequestParams(CancelPaymentRequest request, JSONObject paymentConfig) {
        return null;
    }

    @Override
    protected CancelPaymentResponse processCancelOrderResponse(CancelPaymentResponse response, CancelPaymentRequest request, JSONObject resultJson) {
        return null;
    }

    @Override
    protected JSONObject buildRefundOrderRequestParams(RefundPaymentRequest request, JSONObject paymentConfig) {
        LOGGER.info("\u6784\u5efa\u9000\u6b3e\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570 > ");
        try {
            JSONObject reqParams = this.getRequestHeard(paymentConfig);
            reqParams.put("loginNo", (Object)paymentConfig.getString("merchantLoginNo"));
            reqParams.put("outTradeNo", (Object)request.getOrderNo());
            String refundAmountYuan = BigDecimal.valueOf(request.getRefundAmount()).divide(BigDecimal.valueOf(100L), 2, RoundingMode.DOWN).toPlainString();
            reqParams.put("refundAmount", (Object)refundAmountYuan);
            reqParams.put("_action", (Object)"REFUND");
            return reqParams;
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u652f\u4ed8\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected RefundPaymentResponse processRefundOrderResponse(RefundPaymentResponse response, RefundPaymentRequest request, JSONObject resultJson) {
        LOGGER.info("\u5904\u7406\u8ba2\u5355\u9000\u6b3e\u54cd\u5e94\u7ed3\u679c > ");
        try {
            if (SUCCESS_CODE.equals(resultJson.optString("code"))) {
                if ("P".equals(resultJson.getJSONObject("data").optString("payStatus"))) {
                    String tradeState;
                    response.setRefundId(resultJson.getJSONObject("data").optString("refundOrderId"));
                    response.setOrderNo(resultJson.getJSONObject("data").optString("outTradeNo"));
                    response.setRefundAmount(resultJson.getJSONObject("data").getInt("amount") * 100);
                    PaymentStatus status = switch (tradeState = resultJson.getJSONObject("data").optString("refundStatus")) {
                        case "R" -> PaymentStatus.REFUND_SUCCESS;
                        case "E" -> PaymentStatus.REFUND_FAIL;
                        default -> PaymentStatus.QUERY_REFUND_FAIL;
                    };
                    response.setRefundResult(status.getMessage());
                    response.setCode(status.getCode());
                    response.setMessage(status.getMessage());
                } else {
                    response.setCode(PaymentStatus.PAY_FAIL.getCode());
                    response.setMessage(PaymentStatus.PAY_FAIL.getMessage());
                }
            } else {
                LOGGER.info("\u672c\u6b21\u8ba2\u5355\u9000\u6b3e\u4ea4\u6613\u901a\u4fe1\u5931\u8d25\uff01");
                response.setCode(PaymentStatus.COMMUNICATION_FAIL.getCode());
                response.setMessage(PaymentStatus.COMMUNICATION_FAIL.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u8ba2\u5355\u9000\u6b3e\u8fd4\u56de\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.REFUND_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.QUERY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
        return response;
    }

    @Override
    protected JSONObject buildQueryRefundStatusRequestParams(QueryRefundStatusRequest request, JSONObject paymentConfig) {
        LOGGER.info("\u6784\u5efa\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u8bf7\u6c42\u53c2\u6570 > ");
        try {
            JSONObject reqParams = this.getRequestHeard(paymentConfig);
            reqParams.put("refundNo", (Object)request.getRefundId());
            reqParams.put("_action", (Object)"REFUND_QUERY");
            return reqParams;
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u67e5\u8be2\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.QUERY_REFUND_BUILD_REQUEST_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected QueryRefundStatusResponse processQueryRefundStatusResponse(QueryRefundStatusResponse response, QueryRefundStatusRequest request, JSONObject resultJson) {
        LOGGER.info("\u5904\u7406\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u54cd\u5e94\u7ed3\u679c > ");
        try {
            if (SUCCESS_CODE.equals(resultJson.optString("code"))) {
                String refundStatus;
                JSONObject data = resultJson.optJSONObject("data");
                if (data == null) {
                    response.setCode(PaymentStatus.QUERY_REFUND_FAIL.getCode());
                    response.setMessage("\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u54cd\u5e94\u65e0data\u5b57\u6bb5");
                    return response;
                }
                PaymentStatus status = switch (refundStatus = data.optString("refundStatus")) {
                    case "R" -> PaymentStatus.REFUND_SUCCESS;
                    case "E" -> PaymentStatus.REFUND_FAIL;
                    case "N" -> PaymentStatus.REFUND_NOT_EXIST;
                    default -> PaymentStatus.QUERY_REFUND_FAIL;
                };
                response.setTransactionId(data.optString("outChannelNo"));
                response.setOrderNo(data.optString("outTradeNo"));
                response.setRefundOrderNo(data.optString("outRefundNo"));
                String refundId = data.optString("refundNo");
                if (refundId == null || refundId.isEmpty()) {
                    refundId = data.optString("payOrderRefundId");
                }
                response.setRefundId(refundId);
                double refundAmountYuan = data.optDouble("refundAmount", 0.0);
                response.setRefundAmount((int)Math.round(refundAmountYuan * 100.0));
                String refundTime = data.optString("refundTime");
                if (refundTime != null && !refundTime.isEmpty()) {
                    response.setRefundDateTime(DateTools.formatDateTime((String)refundTime));
                }
                response.setRefundResult(status.getMessage());
                response.setCode(status.getCode());
                response.setMessage(status.getMessage());
            } else {
                LOGGER.info("\u672c\u6b21\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u4ea4\u6613\u901a\u4fe1\u5931\u8d25\uff01");
                response.setCode(PaymentStatus.COMMUNICATION_FAIL.getCode());
                response.setMessage(PaymentStatus.COMMUNICATION_FAIL.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u8fd4\u56de\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.QUERY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.QUERY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
        return response;
    }

    @Override
    protected void signRequest(JSONObject reqParams, JSONObject paymentConfig) {
        try {
            String md5Key = paymentConfig.optString("md5Key");
            if (StringUtils.isEmpty((Object)md5Key)) {
                throw new PaymentException(PaymentStatus.PAY_ORDER_ERROR.getCode(), reqParams.toString(), "\u519c\u5546\u94f6\u884cMD5\u5bc6\u94a5\u672a\u914d\u7f6e");
            }
            LOGGER.info("=== \u7b7e\u540d\u524d\u53c2\u6570\u8be6\u60c5 ===");
            LOGGER.info("\u5f85\u7b7e\u540d\u7684\u539f\u59cb\u53c2\u6570: {}", (Object)reqParams);
            LOGGER.info("\u4f7f\u7528\u7684MD5\u5bc6\u94a5: {}", (Object)md5Key);
            JSONObject signParams = new JSONObject();
            for (String key : reqParams.keySet()) {
                if ("_action".equals(key) || "sign_type".equals(key)) continue;
                signParams.put(key, reqParams.get(key));
            }
            LOGGER.info("\u7528\u4e8e\u7b7e\u540d\u7684\u53c2\u6570\uff08\u5df2\u6392\u9664_action\u548csign_type\uff09: {}", (Object)signParams);
            MD5Utils.signRequestParams(signParams, md5Key);
            reqParams.put("sign", (Object)signParams.getString("sign"));
            LOGGER.info("=== \u7b7e\u540d\u540e\u53c2\u6570\u8be6\u60c5 ===");
            LOGGER.info("\u7b7e\u540d\u540e\u7684\u5b8c\u6574\u53c2\u6570: {}", (Object)reqParams);
        }
        catch (Exception e) {
            LOGGER.error("\u519c\u5546\u94f6\u884c\u8bf7\u6c42\u7b7e\u540d\u5931\u8d25", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_ORDER_ERROR.getCode(), reqParams.toString(), "\u519c\u5546\u94f6\u884c\u8bf7\u6c42\u7b7e\u540d\u5931\u8d25: " + e.getMessage());
        }
    }

    @Override
    protected JSONObject executePaymentRequest(JSONObject reqParams, JSONObject paymentConfig) {
        try {
            JSONObject jsonObject;
            String action;
            String urlKey = switch (action = reqParams.optString("_action", "PAY")) {
                case "QUERY" -> "queryUrl";
                case "REFUND" -> "refundUrl";
                case "REFUND_QUERY" -> "refundQueryUrl";
                default -> "payUrl";
            };
            String url = this.buildRequestUrl(paymentConfig, urlKey);
            JSONObject headers = new JSONObject();
            headers.put("Content-Type", (Object)"application/json");
            JSONObject sendBody = new JSONObject();
            for (String key : reqParams.keySet()) {
                if ("_action".equals(key) || "sign_type".equals(key)) continue;
                sendBody.put(key, reqParams.get(key));
            }
            String requestBody = sendBody.toString();
            LOGGER.info("=== \u53d1\u9001\u8bf7\u6c42\u53c2\u6570\u8be6\u60c5 ===");
            LOGGER.info("\u64cd\u4f5c\u7c7b\u578b: {}", (Object)action);
            LOGGER.info("\u8bf7\u6c42URL: {}", (Object)url);
            LOGGER.info("\u53d1\u9001\u7ed9\u7f51\u5173\u7684\u53c2\u6570\uff08\u5df2\u6392\u9664_action\u548csign_type\uff09: {}", (Object)sendBody);
            LOGGER.info("\u53d1\u9001\u7ed9\u7f51\u5173\u7684JSON\u5b57\u7b26\u4e32: {}", (Object)requestBody);
            String response = RestTools.post((String)url, (String)requestBody, (String)headers.toString());
            try {
                jsonObject = new JSONObject(response);
            }
            catch (Exception e) {
                LOGGER.warn("\u54cd\u5e94\u4e0d\u662fJSON\u683c\u5f0f\uff0c\u5c1d\u8bd5XML\u8f6cJSON: {}", (Object)e.getMessage());
                jsonObject = JsonTools.xmlConvertToJson((String)response);
            }
            LOGGER.info(">>> [{}] \u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)action, (Object)jsonObject);
            return jsonObject;
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u652f\u4ed8\u4e1a\u52a1\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_ORDER_ERROR.getCode(), reqParams.toString(), PaymentStatus.PAY_ORDER_ERROR.getMessage());
        }
    }

    private String buildRequestUrl(JSONObject paymentConfig, String urlKey) {
        String base = paymentConfig.optString("transactionurl", "");
        String specific = paymentConfig.optString(urlKey, "");
        if (specific == null || specific.isEmpty()) {
            return base;
        }
        String lower = specific.toLowerCase();
        if (lower.startsWith("http://") || lower.startsWith("https://")) {
            return specific;
        }
        if (base == null || base.isEmpty()) {
            return specific;
        }
        boolean baseEndsWithSlash = base.endsWith("/");
        boolean specStartsWithSlash = specific.startsWith("/");
        if (baseEndsWithSlash && specStartsWithSlash) {
            return base + specific.substring(1);
        }
        if (!baseEndsWithSlash && !specStartsWithSlash) {
            return base + "/" + specific;
        }
        return base + specific;
    }

    @Override
    protected boolean verifyResponseSign(JSONObject response, JSONObject paymentConfig) {
        try {
            String md5Key = paymentConfig.optString("md5Key", "");
            if (md5Key.isEmpty()) {
                md5Key = paymentConfig.optString("publicKey", "");
                LOGGER.warn("\u672a\u914d\u7f6emd5Key\uff0c\u4f7f\u7528publicKey\u4f5c\u4e3aMD5\u5bc6\u94a5: {}", (Object)md5Key);
            }
            if (md5Key.isEmpty()) {
                LOGGER.error("\u9a8c\u7b7e\u5931\u8d25\uff1a\u672a\u914d\u7f6eMD5\u5bc6\u94a5");
                return false;
            }
            LOGGER.info("\u9a8c\u7b7e\u524d\u7684\u54cd\u5e94\u6570\u636e: {}", (Object)response.toString());
            LOGGER.info("\u4f7f\u7528\u7684MD5\u5bc6\u94a5: {}", (Object)md5Key);
            boolean verifyResult = MD5Utils.verifySign(response, md5Key);
            LOGGER.info("MD5\u9a8c\u7b7e\u7ed3\u679c: {}", (Object)verifyResult);
            return verifyResult;
        }
        catch (Exception e) {
            LOGGER.error("\u9a8c\u7b7e\u5931\u8d25\uff01", (Throwable)e);
            throw new PaymentException(PaymentStatus.VERIFY_SIGN_FAIL.getCode(), "{}", PaymentStatus.VERIFY_SIGN_FAIL.getMessage());
        }
    }

    @Override
    protected JSONObject buildDownloadReconciliationFileRequestParams(DownloadReconciliationFileRequest request, JSONObject paymentConfig) {
        return null;
    }

    @Override
    protected DownloadReconciliationFileResponse processDownloadReconciliationFileResponse(DownloadReconciliationFileResponse response, DownloadReconciliationFileRequest request, JSONObject resultJson) {
        return null;
    }

    private JSONObject getRequestHeard(JSONObject paymentConfig) {
        JSONObject reqParams = new JSONObject();
        reqParams.put("sign_type", (Object)"MD5");
        reqParams.put("nonce_str", (Object)String.valueOf(new Date().getTime()));
        reqParams.put("systemCode", (Object)paymentConfig.optString("systemCode"));
        reqParams.put("version", (Object)"1.0.0");
        reqParams.put("reqtime", (Object)DateTools.getNow((String)"yyyyMMddHHmmss"));
        reqParams.put("rancode", (Object)PaymentUtils.generateRandomString(6));
        reqParams.put("payment", (Object)paymentConfig.optString("channelId"));
        reqParams.put("merchantLoginNo", (Object)paymentConfig.optString("merchantLoginNo"));
        reqParams.put("merchantNo", (Object)paymentConfig.optString("mchId"));
        reqParams.put("key", (Object)paymentConfig.optString("md5Key", paymentConfig.optString("publicKey", "")));
        return reqParams;
    }
}

