/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.utils;

import com.af.v4.system.common.payment.utils.BCECUtils;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.gm.SM2P256V1Curve;

public final class SM2Utils {
    private static final String SM2_ECC_GY_VAL = "BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0";
    private static final String SM2_ECC_GX_VAL = "32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7";
    private static final SM2P256V1Curve CURVE = new SM2P256V1Curve();
    private static final BigInteger SM2_ECC_N = CURVE.getOrder();
    private static final BigInteger SM2_ECC_H = CURVE.getCofactor();
    private static final BigInteger SM2_ECC_GX = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
    private static final BigInteger SM2_ECC_GY = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
    private static final ECPoint G_POINT = CURVE.createPoint(SM2_ECC_GX, SM2_ECC_GY);
    private static final ECDomainParameters DOMAIN_PARAMS = new ECDomainParameters((ECCurve)CURVE, G_POINT, SM2_ECC_N, SM2_ECC_H);

    private SM2Utils() {
    }

    public static AsymmetricCipherKeyPair generateKeyPairParameter() {
        SecureRandom random = new SecureRandom();
        return BCECUtils.generateKeyPairParameter(DOMAIN_PARAMS, random);
    }

    public static byte[] encrypt(BCECPublicKey pubKey, byte[] srcData) throws InvalidCipherTextException {
        return SM2Utils.encrypt(SM2Engine.Mode.C1C3C2, pubKey, srcData);
    }

    public static byte[] encrypt(ECPublicKeyParameters pubKeyParams, byte[] srcData) throws InvalidCipherTextException {
        return SM2Utils.encrypt(SM2Engine.Mode.C1C3C2, pubKeyParams, srcData);
    }

    public static byte[] decrypt(BCECPrivateKey priKey, byte[] sm2Cipher) throws InvalidCipherTextException {
        return SM2Utils.decrypt(SM2Engine.Mode.C1C3C2, priKey, sm2Cipher);
    }

    public static byte[] decrypt(ECPrivateKeyParameters priKeyParams, byte[] sm2Cipher) throws InvalidCipherTextException {
        return SM2Utils.decrypt(SM2Engine.Mode.C1C3C2, priKeyParams, sm2Cipher);
    }

    public static byte[] sign(BCECPrivateKey priKey, byte[] srcData) throws CryptoException {
        return SM2Utils.sign(priKey, null, srcData);
    }

    public static byte[] sign(ECPrivateKeyParameters priKeyParams, byte[] srcData) throws CryptoException {
        return SM2Utils.sign(priKeyParams, null, srcData);
    }

    public static boolean verify(BCECPublicKey pubKey, byte[] srcData, byte[] sign) {
        return SM2Utils.verify(pubKey, null, srcData, sign);
    }

    public static boolean verify(ECPublicKeyParameters pubKeyParams, byte[] srcData, byte[] sign) {
        return SM2Utils.verify(pubKeyParams, null, srcData, sign);
    }

    private static byte[] encrypt(SM2Engine.Mode mode, BCECPublicKey pubKey, byte[] srcData) throws InvalidCipherTextException {
        ECPublicKeyParameters pubKeyParams = BCECUtils.convertPublicKeyToParameters(pubKey);
        return SM2Utils.encrypt(mode, pubKeyParams, srcData);
    }

    private static byte[] encrypt(SM2Engine.Mode mode, ECPublicKeyParameters pubKeyParams, byte[] srcData) throws InvalidCipherTextException {
        SM2Engine engine = new SM2Engine(mode);
        ParametersWithRandom pwr = new ParametersWithRandom((CipherParameters)pubKeyParams, new SecureRandom());
        engine.init(true, (CipherParameters)pwr);
        return engine.processBlock(srcData, 0, srcData.length);
    }

    private static boolean verify(BCECPublicKey pubKey, byte[] withId, byte[] srcData, byte[] sign) {
        ECPublicKeyParameters pubKeyParams = BCECUtils.convertPublicKeyToParameters(pubKey);
        return SM2Utils.verify(pubKeyParams, withId, srcData, sign);
    }

    private static byte[] decrypt(SM2Engine.Mode mode, BCECPrivateKey priKey, byte[] sm2Cipher) throws InvalidCipherTextException {
        ECPrivateKeyParameters priKeyParams = BCECUtils.convertPrivateKeyToParameters(priKey);
        return SM2Utils.decrypt(mode, priKeyParams, sm2Cipher);
    }

    private static byte[] decrypt(SM2Engine.Mode mode, ECPrivateKeyParameters priKeyParams, byte[] sm2Cipher) throws InvalidCipherTextException {
        SM2Engine engine = new SM2Engine(mode);
        engine.init(false, (CipherParameters)priKeyParams);
        return engine.processBlock(sm2Cipher, 0, sm2Cipher.length);
    }

    private static byte[] sign(BCECPrivateKey priKey, byte[] withId, byte[] srcData) throws CryptoException {
        ECPrivateKeyParameters priKeyParams = BCECUtils.convertPrivateKeyToParameters(priKey);
        return SM2Utils.sign(priKeyParams, withId, srcData);
    }

    private static byte[] sign(ECPrivateKeyParameters priKeyParams, byte[] withId, byte[] srcData) throws CryptoException {
        SM2Signer signer = new SM2Signer();
        Object param = null;
        ParametersWithRandom pwr = new ParametersWithRandom((CipherParameters)priKeyParams, new SecureRandom());
        param = withId != null ? new ParametersWithID((CipherParameters)pwr, withId) : pwr;
        signer.init(true, (CipherParameters)param);
        signer.update(srcData, 0, srcData.length);
        return signer.generateSignature();
    }

    private static boolean verify(ECPublicKeyParameters pubKeyParams, byte[] withId, byte[] srcData, byte[] sign) {
        SM2Signer signer = new SM2Signer();
        Object param = withId != null ? new ParametersWithID((CipherParameters)pubKeyParams, withId) : pubKeyParams;
        signer.init(false, (CipherParameters)param);
        signer.update(srcData, 0, srcData.length);
        return signer.verifySignature(sign);
    }
}

