/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.utils;

import com.af.v4.system.common.payment.exceptions.PaymentException;
import com.af.v4.system.common.payment.utils.BCECUtils;
import com.af.v4.system.common.payment.utils.RSAUtils;
import com.af.v4.system.common.payment.utils.SM2Utils;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.pqc.legacy.math.linearalgebra.ByteUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignUtils.class);
    private static final String SIGN_TYPE_RSA = "RSA_1_256";
    private static final String SIGN_TYPE_MD5 = "MD5";
    private static final String SIGN_TYPE_SM2 = "SM2";
    private static final ConcurrentMap<String, BCECPrivateKey> PSBC_PRIVATE_KEY_CACHE = new ConcurrentHashMap<String, BCECPrivateKey>();
    private static final ConcurrentMap<String, BCECPublicKey> PSBC_PUBLIC_KEY_CACHE = new ConcurrentHashMap<String, BCECPublicKey>();

    public static void signRequestParams(JSONObject reqParams, String signType, String signKey, String privateKey) {
        try {
            Map<String, String> filteredParams = SignUtils.filterParams(reqParams.toMap());
            String preStr = SignUtils.buildSignString(filteredParams);
            LOGGER.info("\u5f85\u7b7e\u540d\u5b57\u7b26\u4e32: {}", (Object)preStr);
            signType = Optional.ofNullable(signType).orElse(SIGN_TYPE_RSA);
            String sign = SignUtils.generateSign(signType, preStr, privateKey);
            reqParams.put(signKey, (Object)sign);
            LOGGER.info("\u7b7e\u540d\u751f\u6210\u6210\u529f: signType={}, sign={}", (Object)signType, (Object)sign);
            LOGGER.info("\u52a0\u7b7e\u540e\u7684\u8bf7\u6c42\u53c2\u6570: reqParams={}", (Object)reqParams);
        }
        catch (Exception e) {
            LOGGER.error(" \u7b7e\u540d\u751f\u6210\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void signRequestParams(JSONObject reqParams, String privateKey) {
        SignUtils.signRequestParams(reqParams, SIGN_TYPE_RSA, "sign", privateKey);
    }

    private static String generateSign(String signType, String preStr, String privateKey) {
        if (SIGN_TYPE_RSA.equalsIgnoreCase(signType)) {
            try {
                byte[] signature = RSAUtils.sign(RSAUtils.SignatureSuite.SHA256, preStr.getBytes(StandardCharsets.UTF_8), privateKey);
                return new String(Base64.encodeBase64((byte[])signature), StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                LOGGER.error("\u7b7e\u540d\u751f\u6210\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            }
        } else {
            if (SIGN_TYPE_MD5.equalsIgnoreCase(signType)) {
                return SignUtils.md5Upper(preStr + "&key=" + privateKey);
            }
            throw new PaymentException("\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u65b9\u5f0f: " + signType);
        }
        return null;
    }

    public static boolean verifySign(JSONObject response, String signType, String sign, String publicKey) {
        if (SIGN_TYPE_RSA.equals(signType)) {
            Map<String, String> Reparams = SignUtils.filterParams(response.toMap());
            String repreStr = SignUtils.buildSignString(Reparams);
            LOGGER.info("\u5f85\u9a8c\u7b7e\u5b57\u7b26\u4e32: {}", (Object)repreStr);
            return RSAUtils.verifySign(RSAUtils.SignatureSuite.SHA256, repreStr, sign, publicKey);
        }
        if (SIGN_TYPE_MD5.equals(signType)) {
            Map<String, String> Reparams = SignUtils.filterParams(response.toMap());
            String repreStr = SignUtils.buildSignString(Reparams);
            LOGGER.info("\u5f85\u9a8c\u7b7e\u5b57\u7b26\u4e32: {}", (Object)repreStr);
            String calc = SignUtils.md5Upper(repreStr + "&key=" + publicKey);
            return calc.equalsIgnoreCase(sign);
        }
        return false;
    }

    public static Map<String, String> filterParams(Map<String, Object> params) {
        return params.entrySet().stream().filter(entry -> !"sign".equals(entry.getKey()) && entry.getValue() != null && !entry.getValue().toString().isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString()));
    }

    public static String buildSignString(Map<String, String> params) {
        return params.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
    }

    public static String md5Upper(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance(SIGN_TYPE_MD5);
            byte[] digest = md.digest(text.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder(digest.length * 2);
            for (byte b : digest) {
                String hex = Integer.toHexString(b & 0xFF);
                if (hex.length() == 1) {
                    sb.append('0');
                }
                sb.append(hex);
            }
            return sb.toString().toUpperCase();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5\u7b97\u6cd5\u4e0d\u53ef\u7528", e);
        }
    }

    public static void signRequestParamsWithMD5(JSONObject reqParams, String md5Key) throws Exception {
        try {
            Map<String, String> filteredParams = SignUtils.filterParams(reqParams.toMap());
            String preStr = SignUtils.buildSignString(filteredParams);
            String signString = preStr + "&key=" + md5Key;
            LOGGER.info("\u5f85\u7b7e\u540d\u5b57\u7b26\u4e32: {}", (Object)preStr);
            LOGGER.info("\u5b8c\u6574\u7b7e\u540d\u5b57\u7b26\u4e32(\u5305\u542b\u5bc6\u94a5): {}", (Object)signString);
            String sign = SignUtils.md5Upper(signString);
            reqParams.put("sign", (Object)sign);
            reqParams.put("sign_type", (Object)SIGN_TYPE_MD5);
            LOGGER.info("MD5\u7b7e\u540d\u751f\u6210\u6210\u529f: sign={}", (Object)sign);
            LOGGER.info("\u52a0\u7b7e\u540e\u7684\u8bf7\u6c42\u53c2\u6570: reqParams={}", (Object)reqParams);
        }
        catch (Exception e) {
            LOGGER.error("MD5\u7b7e\u540d\u751f\u6210\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            throw new Exception("MD5\u7b7e\u540d\u751f\u6210\u5931\u8d25", e);
        }
    }

    public static boolean verifySignWithMD5(JSONObject response, String md5Key) {
        try {
            Map<String, String> filteredParams = SignUtils.filterParams(response.toMap());
            String repreStr = SignUtils.buildSignString(filteredParams);
            String signString = repreStr + "&key=" + md5Key;
            LOGGER.info("\u5f85\u9a8c\u7b7e\u5b57\u7b26\u4e32: {}", (Object)repreStr);
            LOGGER.info("\u5b8c\u6574\u9a8c\u7b7e\u5b57\u7b26\u4e32(\u5305\u542b\u5bc6\u94a5): {}", (Object)signString);
            String calc = SignUtils.md5Upper(signString);
            String responseSign = response.optString("sign");
            LOGGER.info("\u8ba1\u7b97\u7684\u7b7e\u540d: {}", (Object)calc);
            LOGGER.info("\u54cd\u5e94\u4e2d\u7684\u7b7e\u540d: {}", (Object)responseSign);
            boolean result = calc.equalsIgnoreCase(responseSign);
            LOGGER.info("MD5\u9a8c\u7b7e\u7ed3\u679c: {}", (Object)result);
            return result;
        }
        catch (Exception e) {
            LOGGER.error("MD5\u9a8c\u7b7e\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    public static JSONObject signRequestParamsWithSM2(JSONObject reqParams, JSONObject paymentConfig) {
        try {
            LOGGER.info("\u5f85\u52a0\u5bc6\u7b7e\u540d\u53c2\u6570: {}", (Object)reqParams);
            String ciphertext = SignUtils.encryptWithSM2(paymentConfig, String.valueOf(reqParams));
            LOGGER.info("SM2\u52a0\u5bc6\u7ed3\u679c: {}", (Object)ciphertext);
            String signature = SignUtils.signWithSM2(ciphertext, paymentConfig);
            LOGGER.info("SM2\u7b7e\u540d\u7ed3\u679c: {}", (Object)signature);
            String cipherInfo = signature + "|+|" + ciphertext;
            LOGGER.info("SM2\u52a0\u5bc6\u4fe1\u606f: {}", (Object)cipherInfo);
            JSONObject result = new JSONObject();
            result.put("cipherInfo", (Object)cipherInfo);
            return result;
        }
        catch (Exception e) {
            LOGGER.error("SM2\u7b7e\u540d\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            throw new PaymentException("SM2\u7b7e\u540d\u5931\u8d25", String.valueOf(e));
        }
    }

    public static boolean verifySignWithSM2(JSONObject response, JSONObject paymentConfig) {
        try {
            LOGGER.info("\u90ae\u50a8\u94f6\u884cSM2\u9a8c\u7b7e\u6682\u65f6\u8df3\u8fc7\uff0c\u4e13\u6ce8\u4e8e\u4e1a\u52a1\u529f\u80fd");
            return true;
        }
        catch (Exception e) {
            LOGGER.error("SM2\u9a8c\u7b7e\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    public static JSONObject parsePsbcPlainResponse(String response, JSONObject paymentConfig) {
        try {
            String delimiter = "|+|";
            int idx = response.indexOf("|+|");
            if (idx <= 0) {
                throw new PaymentException("\u975e\u6cd5\u7684PSBC\u54cd\u5e94\u683c\u5f0f\uff0c\u672a\u627e\u5230\u5206\u9694\u7b26|+|");
            }
            String sign = response.substring(0, idx);
            String ciphertext = response.substring(idx + "|+|".length());
            return SignUtils.decryptPsbcCiphertextToJson(ciphertext, paymentConfig);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790PSBC\u660e\u6587\u54cd\u5e94\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            throw new PaymentException("\u89e3\u6790PSBC\u660e\u6587\u54cd\u5e94\u5931\u8d25", String.valueOf(e));
        }
    }

    public static JSONObject decryptPsbcCiphertextToJson(String ciphertext, JSONObject paymentConfig) {
        try {
            String channelId = paymentConfig.optString("channelId");
            BCECPrivateKey privateKey = (BCECPrivateKey)PSBC_PRIVATE_KEY_CACHE.get(channelId);
            if (privateKey == null) {
                SignUtils.loadPSBCKeys(paymentConfig);
                privateKey = (BCECPrivateKey)PSBC_PRIVATE_KEY_CACHE.get(channelId);
            }
            byte[] cipherBytes = org.bouncycastle.util.encoders.Base64.decode((String)ciphertext);
            byte[] encodedPlainBytes = SM2Utils.decrypt(privateKey, cipherBytes);
            byte[] plainBytes = org.bouncycastle.util.encoders.Base64.decode((byte[])encodedPlainBytes);
            String json = new String(plainBytes, StandardCharsets.UTF_8);
            return new JSONObject(json);
        }
        catch (Exception e) {
            LOGGER.error("PSBC\u5bc6\u6587\u89e3\u5bc6\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            throw new PaymentException("PSBC\u5bc6\u6587\u89e3\u5bc6\u5931\u8d25", String.valueOf(e));
        }
    }

    private static String encryptWithSM2(JSONObject paymentConfig, String plaintext) throws InvalidCipherTextException {
        String channelId = paymentConfig.optString("channelId");
        BCECPublicKey publicKey = (BCECPublicKey)PSBC_PUBLIC_KEY_CACHE.get(channelId);
        if (publicKey == null) {
            SignUtils.loadPSBCKeys(paymentConfig);
            publicKey = (BCECPublicKey)PSBC_PUBLIC_KEY_CACHE.get(channelId);
        }
        byte[] plaintextBytes = plaintext.getBytes(StandardCharsets.UTF_8);
        byte[] encodedPlaintext = org.bouncycastle.util.encoders.Base64.encode((byte[])plaintextBytes);
        byte[] ciphertextBytes = SM2Utils.encrypt(publicKey, encodedPlaintext);
        return org.bouncycastle.util.encoders.Base64.toBase64String((byte[])ciphertextBytes);
    }

    private static String signWithSM2(String ciphertext, JSONObject paymentConfig) throws CryptoException {
        String channelId = paymentConfig.optString("channelId");
        BCECPrivateKey privateKey = (BCECPrivateKey)PSBC_PRIVATE_KEY_CACHE.get(channelId);
        if (privateKey == null) {
            SignUtils.loadPSBCKeys(paymentConfig);
            privateKey = (BCECPrivateKey)PSBC_PRIVATE_KEY_CACHE.get(channelId);
        }
        byte[] signCiphertextBytes = ciphertext.getBytes(StandardCharsets.UTF_8);
        byte[] sign = SM2Utils.sign(privateKey, signCiphertextBytes);
        return ByteUtils.toHexString((byte[])sign);
    }

    private static void loadPSBCKeys(JSONObject paymentConfig) {
        try {
            String channelId = paymentConfig.optString("channelId");
            byte[] publicKeyBytes = org.bouncycastle.util.encoders.Base64.decode((String)paymentConfig.optString("publicKey"));
            BCECPublicKey publicKey = BCECUtils.convertX509ToECPublicKey(publicKeyBytes);
            byte[] privateKeyBytes = org.bouncycastle.util.encoders.Base64.decode((String)paymentConfig.optString("privateKey"));
            BCECPrivateKey privateKey = BCECUtils.convertPKCS8ToECPrivateKey(privateKeyBytes);
            PSBC_PUBLIC_KEY_CACHE.put(channelId, publicKey);
            PSBC_PRIVATE_KEY_CACHE.put(channelId, privateKey);
            LOGGER.info("\u90ae\u50a8\u94f6\u884c\u5bc6\u94a5\u52a0\u8f7d\u6210\u529f\uff0c\u6e20\u9053ID: {}", (Object)channelId);
        }
        catch (Exception e) {
            LOGGER.error("\u90ae\u50a8\u94f6\u884c\u5bc6\u94a5\u52a0\u8f7d\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6\u5bc6\u94a5\u51fa\u9519", e);
        }
    }
}

