/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.utils;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public final class BCECUtils {
    private static final String EC_ALGO_NAME = "EC";

    private BCECUtils() {
    }

    public static AsymmetricCipherKeyPair generateKeyPairParameter(ECDomainParameters domainParams, SecureRandom random) {
        ECKeyPairGenerator generator = new ECKeyPairGenerator();
        ECKeyGenerationParameters params = new ECKeyGenerationParameters(domainParams, random);
        generator.init((KeyGenerationParameters)params);
        return generator.generateKeyPair();
    }

    public static KeyPair generateKeyPair(ECDomainParameters domainParams, SecureRandom random) throws InvalidAlgorithmParameterException {
        ECCurve curve = domainParams.getCurve();
        ECPoint g = domainParams.getG();
        BigInteger n = domainParams.getN();
        BigInteger h = domainParams.getH();
        ECParameterSpec parameterSpec = new ECParameterSpec(curve, g, n, h);
        KeyPairGenerator generator = BCECUtils.getECKeyPairGenerator();
        generator.initialize((AlgorithmParameterSpec)parameterSpec, random);
        return generator.generateKeyPair();
    }

    public static ECPrivateKeyParameters convertPrivateKeyToParameters(BCECPrivateKey privateKey) {
        ECParameterSpec parameterSpec = privateKey.getParameters();
        ECCurve curve = parameterSpec.getCurve();
        ECPoint g = parameterSpec.getG();
        BigInteger n = parameterSpec.getN();
        BigInteger h = parameterSpec.getH();
        ECDomainParameters domainParams = new ECDomainParameters(curve, g, n, h);
        return new ECPrivateKeyParameters(privateKey.getD(), domainParams);
    }

    public static ECPublicKeyParameters convertPublicKeyToParameters(BCECPublicKey publicKey) {
        ECParameterSpec parameterSpec = publicKey.getParameters();
        ECCurve curve = parameterSpec.getCurve();
        ECPoint g = parameterSpec.getG();
        BigInteger n = parameterSpec.getN();
        BigInteger h = parameterSpec.getH();
        ECDomainParameters domainParams = new ECDomainParameters(curve, g, n, h);
        ECPoint q = publicKey.getQ();
        return new ECPublicKeyParameters(q, domainParams);
    }

    public static byte[] convertECPrivateKeyToPKCS8(ECPrivateKeyParameters privateKeyParams, ECPublicKeyParameters publicKeyParams) {
        ECDomainParameters domainParams = privateKeyParams.getParameters();
        ECCurve curve = domainParams.getCurve();
        ECPoint g = domainParams.getG();
        BigInteger n = domainParams.getN();
        BigInteger h = domainParams.getH();
        ECParameterSpec spec = new ECParameterSpec(curve, g, n, h);
        BCECPublicKey publicKey = null;
        if (publicKeyParams != null) {
            publicKey = new BCECPublicKey(EC_ALGO_NAME, publicKeyParams, spec, BouncyCastleProvider.CONFIGURATION);
        }
        BCECPrivateKey privateKey = new BCECPrivateKey(EC_ALGO_NAME, privateKeyParams, publicKey, spec, BouncyCastleProvider.CONFIGURATION);
        return privateKey.getEncoded();
    }

    public static BCECPrivateKey convertPKCS8ToECPrivateKey(byte[] pkcs8Key) throws InvalidKeySpecException {
        PKCS8EncodedKeySpec peks = new PKCS8EncodedKeySpec(pkcs8Key);
        KeyFactory keyFactory = BCECUtils.getECKeyFactory();
        return (BCECPrivateKey)keyFactory.generatePrivate(peks);
    }

    public static byte[] convertECPublicKeyToX509(ECPublicKeyParameters publicKeyParams) {
        ECDomainParameters domainParams = publicKeyParams.getParameters();
        ECCurve curve = domainParams.getCurve();
        ECPoint g = domainParams.getG();
        BigInteger n = domainParams.getN();
        BigInteger h = domainParams.getH();
        ECParameterSpec spec = new ECParameterSpec(curve, g, n, h);
        BCECPublicKey publicKey = new BCECPublicKey(EC_ALGO_NAME, publicKeyParams, spec, BouncyCastleProvider.CONFIGURATION);
        return publicKey.getEncoded();
    }

    public static BCECPublicKey convertX509ToECPublicKey(byte[] x509Bytes) throws InvalidKeySpecException {
        X509EncodedKeySpec eks = new X509EncodedKeySpec(x509Bytes);
        KeyFactory keyFactory = BCECUtils.getECKeyFactory();
        return (BCECPublicKey)keyFactory.generatePublic(eks);
    }

    private static KeyFactory getECKeyFactory() {
        try {
            return KeyFactory.getInstance(EC_ALGO_NAME, "BC");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static KeyPairGenerator getECKeyPairGenerator() {
        try {
            return KeyPairGenerator.getInstance(EC_ALGO_NAME, "BC");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    static {
        try {
            if (Security.getProvider("BC") == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u65e0\u6cd5\u6ce8\u518cBouncyCastle\u63d0\u4f9b\u7a0b\u5e8f", e);
        }
    }
}

