/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.dto;

import org.json.JSONObject;

public class QueryPaymentStatusRequest {
    private final String orderNo;
    private final String transactionId;
    private final String bankName;
    private final String orgName;
    private final JSONObject customParams;

    private QueryPaymentStatusRequest(Builder builder) {
        this.orderNo = builder.orderNo;
        this.bankName = builder.bankName;
        this.orgName = builder.orgName;
        this.transactionId = builder.transactionId;
        this.customParams = builder.customParams;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public String getBankName() {
        return this.bankName;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public JSONObject getCustomParams() {
        return this.customParams;
    }

    public static class Builder {
        private String orderNo;
        private String bankName;
        private String orgName;
        private String transactionId;
        private JSONObject customParams;

        public static Builder fromJsonObject(JSONObject jsonObject) {
            Builder builder = new Builder();
            if (jsonObject == null) {
                return builder;
            }
            if (jsonObject.has("orderNo")) {
                builder.orderNo(jsonObject.getString("orderNo"));
            }
            if (jsonObject.has("bankName")) {
                builder.bankName(jsonObject.getString("bankName"));
            }
            if (jsonObject.has("orgName")) {
                builder.orgName(jsonObject.getString("orgName"));
            }
            if (jsonObject.has("transactionId")) {
                builder.transactionId(jsonObject.getString("transactionId"));
            }
            builder.customParams(jsonObject.optJSONObject("customParams", new JSONObject()));
            return builder;
        }

        public Builder orderNo(String orderNo) {
            this.orderNo = orderNo;
            return this;
        }

        public Builder orgName(String orgName) {
            this.orgName = orgName;
            return this;
        }

        public Builder bankName(String bankName) {
            this.bankName = bankName;
            return this;
        }

        public Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public Builder customParams(JSONObject customParams) {
            this.customParams = customParams;
            return this;
        }

        public QueryPaymentStatusRequest build() {
            return new QueryPaymentStatusRequest(this);
        }
    }
}

