/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.handler.impl.sxxh;

import com.af.v4.system.common.payment.annotation.PaymentHandlerConfig;
import com.af.v4.system.common.payment.dto.CancelPaymentRequest;
import com.af.v4.system.common.payment.dto.CancelPaymentResponse;
import com.af.v4.system.common.payment.dto.PaymentOrderRequest;
import com.af.v4.system.common.payment.dto.PaymentOrderResponse;
import com.af.v4.system.common.payment.dto.QueryPaymentStatusRequest;
import com.af.v4.system.common.payment.dto.QueryPaymentStatusResponse;
import com.af.v4.system.common.payment.dto.QueryRefundStatusRequest;
import com.af.v4.system.common.payment.dto.QueryRefundStatusResponse;
import com.af.v4.system.common.payment.dto.RefundPaymentRequest;
import com.af.v4.system.common.payment.dto.RefundPaymentResponse;
import com.af.v4.system.common.payment.enums.BankName;
import com.af.v4.system.common.payment.enums.IntegrationType;
import com.af.v4.system.common.payment.enums.PaymentStatus;
import com.af.v4.system.common.payment.exceptions.PaymentException;
import com.af.v4.system.common.payment.handler.impl.AbstractPaymentHandler;
import com.af.v4.system.common.plugins.date.DateTools;
import com.af.v4.system.common.plugins.http.RestTools;
import com.af.v4.system.common.plugins.json.JsonTools;
import java.io.FileInputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.Enumeration;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@PaymentHandlerConfig(bankName=BankName.SXXH, integrationType=IntegrationType.AGGREGATE)
public class ShanXiXinHeAbstractPaymentHandler
extends AbstractPaymentHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShanXiXinHeAbstractPaymentHandler.class);
    private static final String SUCCESS_CODE = "000000";

    @Override
    protected JSONObject buildPayOrderRequestParams(PaymentOrderRequest request, JSONObject paymentConfig) {
        LOGGER.info(">>> \u6784\u5efa\u9655\u897f\u4fe1\u5408\u652f\u4ed8\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570 > ");
        try {
            JSONObject reqParams = new JSONObject();
            reqParams.put("versionNo", (Object)"1.0.0");
            reqParams.put("orderTime", (Object)DateTools.getNow((String)"yyyy-MM-dd HH:mm:ss.SSS"));
            reqParams.put("merchDate", (Object)DateTools.getNow((String)"yyyyMMdd"));
            reqParams.put("frontURL", (Object)paymentConfig.optString("backUrl"));
            reqParams.put("ccy", (Object)"CNY");
            reqParams.put("qrpCodeFlag", (Object)"02");
            reqParams.put("merchId", (Object)paymentConfig.optString("merchId"));
            reqParams.put("merchOrderId", (Object)request.getOrderNo());
            reqParams.put("orderName", (Object)paymentConfig.optString("body", request.getDescription()));
            String amountYuan = BigDecimal.valueOf(request.getAmount()).divide(BigDecimal.valueOf(100L), 2, RoundingMode.DOWN).toPlainString();
            reqParams.put("txnAmt", (Object)amountYuan);
            return reqParams;
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u9655\u897f\u4fe1\u5408\u652f\u4ed8\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected PaymentOrderResponse processPayOrderResponse(PaymentOrderResponse response, PaymentOrderRequest request, JSONObject resultJson, JSONObject paymentConfig) {
        LOGGER.info(">>> \u5904\u7406\u9655\u897f\u4fe1\u5408\u652f\u4ed8\u8ba2\u5355\u54cd\u5e94\u7ed3\u679c > ");
        try {
            if (JsonTools.isContains((JSONObject)resultJson, (String)"url")) {
                response.setState(PaymentStatus.PAY_SUCCESS);
                response.setOrderNo(request.getOrderNo());
                response.setPayUrl(resultJson.optString("url"));
                response.setNeedQuery(true);
                response.setPayResult("\u4e0b\u5355\u6210\u529f\uff0c\u7b49\u5f85\u652f\u4ed8");
                response.setQrCodeType("02");
                response.setAllowRefunds("1");
                response.setAllowCancel("0");
            } else {
                LOGGER.info("\u9655\u897f\u4fe1\u5408\u652f\u4ed8\u8ba2\u5355\u4e0b\u5355\u5931\u8d25\uff1a{}", (Object)resultJson);
                response.setState(PaymentStatus.PAY_FAIL);
                response.setCode(PaymentStatus.PAY_FAIL.getCode());
                response.setMessage(resultJson.optString("msg", "\u4e0b\u5355\u5931\u8d25"));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5904\u7406\u9655\u897f\u4fe1\u5408\u652f\u4ed8\u8ba2\u5355\u8fd4\u56de\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
        return response;
    }

    @Override
    protected JSONObject buildQueryPaymentStatusRequestParams(QueryPaymentStatusRequest request, JSONObject paymentConfig) {
        LOGGER.info(">>> \u6784\u5efa\u9655\u897f\u4fe1\u5408\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u8bf7\u6c42\u53c2\u6570 > ");
        try {
            JSONObject reqParams = new JSONObject();
            reqParams.put("versionNo", (Object)"1.0.0");
            reqParams.put("merchDate", (Object)DateTools.getNow((String)"yyyyMMdd"));
            reqParams.put("merchId", (Object)paymentConfig.optString("merchId"));
            reqParams.put("merchOrderId", (Object)request.getOrderNo());
            reqParams.put("orderType", (Object)"01");
            return reqParams;
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u9655\u897f\u4fe1\u5408\u67e5\u8be2\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.QUERY_ORDER_BUILD_REQUEST_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.QUERY_ORDER_BUILD_REQUEST_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected QueryPaymentStatusResponse processQueryPaymentStatusResponse(QueryPaymentStatusResponse response, QueryPaymentStatusRequest request, JSONObject resultJson) {
        LOGGER.info("\u5904\u7406\u9655\u897f\u4fe1\u5408\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u54cd\u5e94\u7ed3\u679c > ");
        try {
            if (SUCCESS_CODE.equals(resultJson.optString("retCode"))) {
                String txnStat = resultJson.optString("txnStat");
                response.setOrderNo(request.getOrderNo());
                response.setMchId(resultJson.optString("merchId"));
                PaymentStatus status = switch (txnStat) {
                    case "01" -> {
                        response.setPaymentStatus("\u4ea4\u6613\u5904\u7406\u4e2d");
                        yield PaymentStatus.PAYMENT_IN_PROGRESS;
                    }
                    case "02" -> {
                        response.setPaymentStatus("\u652f\u4ed8\u6210\u529f");
                        response.setTransactionId(resultJson.optString("txnSeq"));
                        String payTime = resultJson.optString("txnTime");
                        if (StringUtils.hasText((String)payTime)) {
                            response.setPaySuccessDate(DateTools.formatDateTime((String)payTime));
                        }
                        yield PaymentStatus.SUCCESS_FOR_PAYMENT;
                    }
                    case "03" -> {
                        response.setPaymentStatus("\u652f\u4ed8\u5931\u8d25");
                        yield PaymentStatus.FAIL_FOR_PAYMENT;
                    }
                    case "04" -> {
                        response.setPaymentStatus("\u8ba2\u5355\u4e0d\u5b58\u5728");
                        yield PaymentStatus.CANCEL_FOR_PAYMENT;
                    }
                    default -> {
                        response.setPaymentStatus("\u672a\u77e5\u72b6\u6001");
                        yield PaymentStatus.QUERY_ORDER_FAIL;
                    }
                };
                response.setState(status);
            } else {
                LOGGER.info("\u9655\u897f\u4fe1\u5408\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u5931\u8d25\uff1a{}", (Object)resultJson);
                response.setState(PaymentStatus.QUERY_ORDER_FAIL);
                response.setCode(PaymentStatus.QUERY_ORDER_FAIL.getCode());
                response.setMessage(resultJson.optString("retMsg", "\u67e5\u8be2\u5931\u8d25"));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5904\u7406\u9655\u897f\u4fe1\u5408\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u8fd4\u56de\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.QUERY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.QUERY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
        return response;
    }

    @Override
    protected JSONObject buildCancelOrderRequestParams(CancelPaymentRequest request, JSONObject paymentConfig) {
        LOGGER.warn("\u9655\u897f\u4fe1\u5408\u4e0d\u652f\u6301\u53d6\u6d88\u8ba2\u5355\u64cd\u4f5c");
        return null;
    }

    @Override
    protected CancelPaymentResponse processCancelOrderResponse(CancelPaymentResponse response, CancelPaymentRequest request, JSONObject resultJson) {
        response.setCode(PaymentStatus.OPERATION_NOT_SUPPORTED.getCode());
        response.setMessage("\u9655\u897f\u4fe1\u5408\u4e0d\u652f\u6301\u53d6\u6d88\u8ba2\u5355\u64cd\u4f5c");
        return response;
    }

    @Override
    protected JSONObject buildRefundOrderRequestParams(RefundPaymentRequest request, JSONObject paymentConfig) {
        LOGGER.info("\u6784\u5efa\u9655\u897f\u4fe1\u5408\u9000\u6b3e\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570 > ");
        try {
            JSONObject reqParams = new JSONObject();
            reqParams.put("versionNo", (Object)"1.0.0");
            reqParams.put("merchTime", (Object)DateTools.getNow((String)"yyyyMMddHHmmss"));
            reqParams.put("merchDate", (Object)DateTools.getNow((String)"yyyyMMdd"));
            reqParams.put("ccy", (Object)"CNY");
            reqParams.put("merchId", (Object)paymentConfig.optString("merchId"));
            reqParams.put("backURL", (Object)paymentConfig.optString("refundBackUrl"));
            reqParams.put("primMerchOrderId", (Object)request.getOrderNo());
            reqParams.put("primMerchOrderDate", (Object)DateTools.getNow((String)"yyyyMMdd"));
            String refundAmountYuan = BigDecimal.valueOf(request.getRefundAmount()).divide(BigDecimal.valueOf(100L), 2, RoundingMode.DOWN).toPlainString();
            reqParams.put("txnAmt", (Object)refundAmountYuan);
            reqParams.put("refundAmt", (Object)refundAmountYuan);
            reqParams.put("refundMerchOrderId", (Object)request.getRefundOrderNo());
            return reqParams;
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u9655\u897f\u4fe1\u5408\u9000\u6b3e\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.REFUND_BUILD_REQUEST_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.REFUND_BUILD_REQUEST_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected RefundPaymentResponse processRefundOrderResponse(RefundPaymentResponse response, RefundPaymentRequest request, JSONObject resultJson) {
        LOGGER.info("\u5904\u7406\u9655\u897f\u4fe1\u5408\u8ba2\u5355\u9000\u6b3e\u54cd\u5e94\u7ed3\u679c > ");
        try {
            if (SUCCESS_CODE.equals(resultJson.optString("retCode"))) {
                response.setRefundId(request.getRefundOrderNo());
                response.setOrderNo(request.getOrderNo());
                response.setRefundAmount(request.getRefundAmount());
                response.setRefundResult("\u9000\u6b3e\u7533\u8bf7\u6210\u529f");
                response.setState(PaymentStatus.REFUND_SUCCESS);
            } else {
                LOGGER.info("\u9655\u897f\u4fe1\u5408\u8ba2\u5355\u9000\u6b3e\u5931\u8d25\uff1a{}", (Object)resultJson);
                response.setState(PaymentStatus.REFUND_FAIL);
                response.setCode(PaymentStatus.REFUND_FAIL.getCode());
                response.setMessage(resultJson.optString("retMsg", "\u9000\u6b3e\u5931\u8d25"));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5904\u7406\u9655\u897f\u4fe1\u5408\u8ba2\u5355\u9000\u6b3e\u8fd4\u56de\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.REFUND_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.REFUND_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
        return response;
    }

    @Override
    protected JSONObject buildQueryRefundStatusRequestParams(QueryRefundStatusRequest request, JSONObject paymentConfig) {
        LOGGER.info("\u6784\u5efa\u9655\u897f\u4fe1\u5408\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u8bf7\u6c42\u53c2\u6570 > ");
        try {
            JSONObject reqParams = new JSONObject();
            reqParams.put("versionNo", (Object)"1.0.0");
            reqParams.put("merchDate", (Object)DateTools.getNow((String)"yyyyMMdd"));
            reqParams.put("merchId", (Object)paymentConfig.optString("merchId"));
            reqParams.put("merchOrderId", (Object)request.getRefundId());
            reqParams.put("orderType", (Object)"02");
            return reqParams;
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u9655\u897f\u4fe1\u5408\u67e5\u8be2\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.QUERY_REFUND_BUILD_REQUEST_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.QUERY_REFUND_BUILD_REQUEST_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected QueryRefundStatusResponse processQueryRefundStatusResponse(QueryRefundStatusResponse response, QueryRefundStatusRequest request, JSONObject resultJson) {
        LOGGER.info("\u5904\u7406\u9655\u897f\u4fe1\u5408\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u54cd\u5e94\u7ed3\u679c > ");
        try {
            if (SUCCESS_CODE.equals(resultJson.optString("retCode"))) {
                String txnStat = resultJson.optString("txnStat");
                response.setRefundId(request.getRefundId());
                response.setOrderNo(resultJson.optString("primMerchOrderId"));
                response.setTransactionId(resultJson.optString("txnSeq"));
                PaymentStatus status = switch (txnStat) {
                    case "01" -> {
                        response.setRefundResult("\u9000\u6b3e\u5904\u7406\u4e2d");
                        yield PaymentStatus.REFUND_PROCESSING;
                    }
                    case "02" -> {
                        response.setRefundResult("\u9000\u6b3e\u6210\u529f");
                        String refundTime = resultJson.optString("txnTime");
                        if (StringUtils.hasText((String)refundTime)) {
                            response.setRefundDateTime(DateTools.formatDateTime((String)refundTime));
                        }
                        yield PaymentStatus.REFUND_SUCCESS;
                    }
                    case "03" -> {
                        response.setRefundResult("\u9000\u6b3e\u5931\u8d25");
                        yield PaymentStatus.REFUND_FAIL;
                    }
                    default -> {
                        response.setRefundResult("\u672a\u77e5\u72b6\u6001");
                        yield PaymentStatus.QUERY_REFUND_FAIL;
                    }
                };
                response.setState(status);
            } else {
                LOGGER.info("\u9655\u897f\u4fe1\u5408\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u5931\u8d25\uff1a{}", (Object)resultJson);
                response.setState(PaymentStatus.QUERY_REFUND_FAIL);
                response.setCode(PaymentStatus.QUERY_REFUND_FAIL.getCode());
                response.setMessage(resultJson.optString("retMsg", "\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u5931\u8d25"));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5904\u7406\u9655\u897f\u4fe1\u5408\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u8fd4\u56de\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.QUERY_REFUND_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.QUERY_REFUND_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
        return response;
    }

    @Override
    protected void signRequest(JSONObject reqParams, JSONObject paymentConfig) {
        try {
            String pfxUrl = paymentConfig.optString("pfxUrl");
            String pfxPwd = paymentConfig.optString("pfxPwd");
            if (StringUtils.isEmpty((Object)pfxUrl) || StringUtils.isEmpty((Object)pfxPwd)) {
                throw new PaymentException(PaymentStatus.PAY_ORDER_ERROR.getCode(), reqParams.toString(), "\u9655\u897f\u4fe1\u5408\u7b7e\u540d\u8bc1\u4e66\u672a\u914d\u7f6e");
            }
            String transData = this.appendParam(reqParams);
            String signStr = this.sxxhSign(transData, pfxUrl, pfxPwd);
            reqParams.clear();
            reqParams.put("transData", (Object)transData);
            reqParams.put("signMsg", (Object)signStr);
            LOGGER.info("\u9655\u897f\u4fe1\u5408\u7b7e\u540d\u540e\u7684\u8bf7\u6c42\u53c2\u6570: {}", (Object)reqParams);
        }
        catch (Exception e) {
            LOGGER.error("\u9655\u897f\u4fe1\u5408\u8bf7\u6c42\u7b7e\u540d\u5931\u8d25", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_ORDER_ERROR.getCode(), reqParams.toString(), "\u9655\u897f\u4fe1\u5408\u8bf7\u6c42\u7b7e\u540d\u5931\u8d25: " + e.getMessage());
        }
    }

    @Override
    protected JSONObject executePaymentRequest(JSONObject reqParams, JSONObject paymentConfig) {
        try {
            String url;
            if (reqParams.has("orderType")) {
                String orderType;
                String string = orderType = reqParams.getJSONObject("transData") != null ? new JSONObject(reqParams.getString("transData")).optString("orderType") : "01";
                url = "02".equals(orderType) ? paymentConfig.optString("queryUrl") : paymentConfig.optString("queryUrl");
            } else {
                url = reqParams.toString().contains("refundAmt") ? paymentConfig.optString("refundUrl") : paymentConfig.optString("payUrl");
            }
            JSONObject headers = new JSONObject();
            headers.put("Content-Type", (Object)"application/x-www-form-urlencoded");
            String requestBody = "transData=" + reqParams.getString("transData") + "&signMsg=" + reqParams.getString("signMsg");
            LOGGER.info(">>> \u9655\u897f\u4fe1\u5408\u8bf7\u6c42URL={}, \u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)url, (Object)requestBody);
            String response = RestTools.post((String)url, (String)requestBody, (String)headers.toString());
            if (!this.sxxhVerifyData(response)) {
                throw new PaymentException(PaymentStatus.VERIFY_SIGN_FAIL.getCode(), response, "\u9655\u897f\u4fe1\u5408\u54cd\u5e94\u9a8c\u7b7e\u5931\u8d25");
            }
            JSONObject jsonObject = JsonTools.convertToJson((String)response);
            LOGGER.info(">>> \u9655\u897f\u4fe1\u5408\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)jsonObject);
            return jsonObject;
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u9655\u897f\u4fe1\u5408\u4e1a\u52a1\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_ORDER_ERROR.getCode(), reqParams.toString(), PaymentStatus.PAY_ORDER_ERROR.getMessage());
        }
    }

    @Override
    protected boolean verifyResponseSign(JSONObject response, JSONObject paymentConfig) {
        return true;
    }

    private String appendParam(JSONObject params) {
        StringBuilder sb = new StringBuilder();
        for (String key : params.keySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(key).append("=").append(params.opt(key));
        }
        return sb.toString();
    }

    private String sxxhSign(String transData, String pfxUrl, String pfxPwd) {
        try {
            PrivateKey privateKey = this.getSignCertPrivateKeyByStoreMap(pfxUrl, pfxPwd);
            byte[] result = this.signBySoft(privateKey, transData.getBytes("utf-8"));
            String signStr = Base64.encodeBase64String((byte[])result);
            LOGGER.debug("\u9655\u897f\u4fe1\u5408\u7b7e\u540d\u6210\u529f\uff0c\u6570\u636e\u957f\u5ea6: {}", (Object)signStr.length());
            return signStr;
        }
        catch (Exception e) {
            LOGGER.error("\u9655\u897f\u4fe1\u5408\u7b7e\u540d\u5931\u8d25", (Throwable)e);
            throw new PaymentException(PaymentStatus.SIGN_FAIL.getCode(), transData, "\u9655\u897f\u4fe1\u5408\u7b7e\u540d\u5931\u8d25: " + e.getMessage());
        }
    }

    private byte[] signBySoft(PrivateKey privateKey, byte[] data) throws Exception {
        Signature signature = Signature.getInstance("SHA256withRSA");
        signature.initSign(privateKey);
        signature.update(data);
        byte[] result = signature.sign();
        String s = Base64.encodeBase64String((byte[])result);
        LOGGER.debug("\u7b7e\u540d\u7ed3\u679c: {}", (Object)s);
        return result;
    }

    private PrivateKey getSignCertPrivateKeyByStoreMap(String certPath, String password) throws Exception {
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            try (FileInputStream fis = new FileInputStream(certPath);){
                keyStore.load(fis, password.toCharArray());
            }
            Enumeration<String> aliases = keyStore.aliases();
            String alias = null;
            while (aliases.hasMoreElements()) {
                String currentAlias = aliases.nextElement();
                if (!keyStore.isKeyEntry(currentAlias)) continue;
                alias = currentAlias;
                break;
            }
            if (alias == null) {
                throw new Exception("\u8bc1\u4e66\u4e2d\u672a\u627e\u5230\u79c1\u94a5\u6761\u76ee");
            }
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
            if (privateKey == null) {
                throw new Exception("\u65e0\u6cd5\u4ece\u8bc1\u4e66\u4e2d\u83b7\u53d6\u79c1\u94a5");
            }
            LOGGER.debug("\u6210\u529f\u4ece\u8bc1\u4e66\u83b7\u53d6\u79c1\u94a5\uff0c\u7b97\u6cd5: {}", (Object)privateKey.getAlgorithm());
            return privateKey;
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u8bc1\u4e66\u79c1\u94a5\u5931\u8d25\uff0c\u8bc1\u4e66\u8def\u5f84: {}", (Object)certPath, (Object)e);
            throw new Exception("\u83b7\u53d6\u8bc1\u4e66\u79c1\u94a5\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private boolean sxxhVerifyData(String response) {
        boolean isValid = response != null && response.startsWith("{");
        LOGGER.debug("\u9655\u897f\u4fe1\u5408\u9a8c\u7b7e\u7ed3\u679c: {}, \u54cd\u5e94\u6570\u636e\u957f\u5ea6: {}", (Object)isValid, (Object)(response != null ? response.length() : 0));
        if (!isValid) {
            LOGGER.warn("\u9655\u897f\u4fe1\u5408\u9a8c\u7b7e\u5931\u8d25\uff0c\u54cd\u5e94\u6570\u636e: {}", (Object)response);
        }
        return isValid;
    }
}

