package com.af.v4.system.common.payment.dto;

import com.af.v4.system.common.payment.enums.PaymentStatus;
import com.af.v4.system.common.payment.utils.PaymentUtils;
import org.json.JSONObject;

/**
 * 查询退款状态响应
 *
 * @author llzh
 * @DateTime 2024/12/30 14:06
 */
public class QueryRefundStatusResponse {
    /**
     * 返回码
     */
    private String code;
    /**
     * 返回描述
     */
    private String message;
    /**
     * 商户号
     */
    private String mchId;
    /**
     * 商户订单号（业务系统生成的唯一订单号）
     */
    private String orderNo;
    /**
     * 第三方订单号
     */
    private String transactionId;
    /**
     * 退款订单号（业务系统生成的唯一退款订单号）
     */
    private String refundOrderNo;
    /**
     * 平台退款单号
     */
    private String refundId;
    /**
     * 退款金额（单位：分）
     */
    private int refundAmount;
    /**
     * 退款时间
     */
    private String refundDateTime;
    /**
     * 退款结果
     */
    private String refundResult;
    /**
     * 请求报文
     */
    private JSONObject requestJson;


    public JSONObject buildJson(){
        return  PaymentUtils.toJson(this);
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public JSONObject getRequestJson() {
        return requestJson;
    }

    public void setRequestJson(JSONObject requestJson) {
        this.requestJson = requestJson;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getRefundOrderNo() {
        return refundOrderNo;
    }

    public void setRefundOrderNo(String refundOrderNo) {
        this.refundOrderNo = refundOrderNo;
    }

    public String getRefundId() {
        return refundId;
    }

    public void setRefundId(String refundId) {
        this.refundId = refundId;
    }

    public int getRefundAmount() {
        return refundAmount;
    }

    public void setRefundAmount(int refundAmount) {
        this.refundAmount = refundAmount;
    }

    public String getRefundDateTime() {
        return refundDateTime;
    }

    public void setRefundDateTime(String refundDateTime) {
        this.refundDateTime = refundDateTime;
    }


    public String getMchId() {
        return mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getRefundResult() {
        return refundResult;
    }

    public void setRefundResult(String refundResult) {
        this.refundResult = refundResult;
    }

    public void setState(PaymentStatus paymentStatus) {
        this.code = paymentStatus.getCode();
        this.message = paymentStatus.getMessage();
    }
}