/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.dto;

import org.json.JSONObject;

public class PaymentOrderRequest {
    private final String orderNo;
    private final int amount;
    private final String authCode;
    private final String description;
    private final String notifyUrl;
    private final String userInfoCode;
    private final String customParam;
    private final String bankName;
    private final String orgName;

    private PaymentOrderRequest(Builder builder) {
        this.orderNo = builder.orderNo;
        this.amount = builder.amount;
        this.authCode = builder.authCode;
        this.description = builder.description;
        this.notifyUrl = builder.notifyUrl;
        this.userInfoCode = builder.userInfoCode;
        this.customParam = builder.customParam;
        this.bankName = builder.bankName;
        this.orgName = builder.orgName;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public int getAmount() {
        return this.amount;
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public String getDescription() {
        return this.description;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public String getUserInfoCode() {
        return this.userInfoCode;
    }

    public String getCustomParam() {
        return this.customParam;
    }

    public String getBankName() {
        return this.bankName;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public static class Builder {
        private String orderNo;
        private int amount;
        private String authCode;
        private String description;
        private String notifyUrl;
        private String userInfoCode;
        private String customParam;
        private String bankName;
        private String orgName;

        public static Builder fromJsonObject(JSONObject jsonObject) {
            Builder builder = new Builder();
            if (jsonObject == null) {
                return builder;
            }
            if (jsonObject.has("orderNo")) {
                builder.orderNo(jsonObject.getString("orderNo"));
            }
            if (jsonObject.has("amount")) {
                builder.amount(jsonObject.getInt("amount"));
            }
            if (jsonObject.has("authCode")) {
                builder.authCode(jsonObject.getString("authCode"));
            }
            if (jsonObject.has("description")) {
                builder.description(jsonObject.getString("description"));
            }
            if (jsonObject.has("notifyUrl")) {
                builder.notifyUrl(jsonObject.getString("notifyUrl"));
            }
            if (jsonObject.has("userInfoCode")) {
                builder.userInfoCode(jsonObject.getString("userInfoCode"));
            }
            if (jsonObject.has("customParam")) {
                builder.customParam(jsonObject.getString("customParam"));
            }
            if (jsonObject.has("bankName")) {
                builder.bankName(jsonObject.getString("bankName"));
            }
            if (jsonObject.has("orgName")) {
                builder.orgName(jsonObject.getString("orgName"));
            }
            return builder;
        }

        public Builder orderNo(String orderNo) {
            this.orderNo = orderNo;
            return this;
        }

        public Builder amount(int amount) {
            this.amount = amount;
            return this;
        }

        public Builder authCode(String authCode) {
            this.authCode = authCode;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder notifyUrl(String notifyUrl) {
            this.notifyUrl = notifyUrl;
            return this;
        }

        public Builder userInfoCode(String userInfoCode) {
            this.userInfoCode = userInfoCode;
            return this;
        }

        public Builder customParam(String customParam) {
            this.customParam = customParam;
            return this;
        }

        public Builder orgName(String orgName) {
            this.orgName = orgName;
            return this;
        }

        public Builder bankName(String bankName) {
            this.bankName = bankName;
            return this;
        }

        public PaymentOrderRequest build() {
            return new PaymentOrderRequest(this);
        }
    }
}

