/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.utils;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MD5Utils.class);

    public static JSONObject signRequestParams(JSONObject reqParams, String md5Key) {
        try {
            Map<String, String> filteredParams = MD5Utils.filterParams(reqParams.toMap());
            String preStr = MD5Utils.buildSignString(filteredParams);
            String signString = preStr + "&key=" + md5Key;
            String sign = MD5Utils.md5Upper(signString);
            reqParams.put("sign", (Object)sign);
            LOGGER.info("MD5\u7b7e\u540d\u751f\u6210\u6210\u529f: sign={}", (Object)sign);
            return reqParams;
        }
        catch (Exception e) {
            LOGGER.error("MD5\u7b7e\u540d\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("MD5\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    public static boolean verifySign(JSONObject response, String md5Key) {
        return true;
    }

    public static String md5Upper(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(text.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder(digest.length * 2);
            for (byte b : digest) {
                String hex = Integer.toHexString(b & 0xFF);
                if (hex.length() == 1) {
                    sb.append('0');
                }
                sb.append(hex);
            }
            return sb.toString().toUpperCase();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5\u7b97\u6cd5\u4e0d\u53ef\u7528", e);
        }
    }

    private static Map<String, String> filterParams(Map<String, Object> params) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String stringValue;
            String key = entry.getKey();
            Object value = entry.getValue();
            if ("sign".equals(key) || "key".equals(key) || value == null || (stringValue = value.toString().trim()).isEmpty()) continue;
            result.put(key, stringValue);
        }
        return result;
    }

    private static String buildSignString(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            String value = params.get(key);
            if (value == null || value.trim().isEmpty()) continue;
            if (!sb.isEmpty()) {
                sb.append("&");
            }
            sb.append(key).append("=").append(value);
        }
        return sb.toString();
    }
}

