/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.dto;

import org.json.JSONObject;

public class CancelPaymentRequest {
    private final String orderNo;
    private final String bankName;
    private final String orgName;

    private CancelPaymentRequest(Builder builder) {
        this.orderNo = builder.orderNo;
        this.bankName = builder.bankName;
        this.orgName = builder.orgName;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public String getBankName() {
        return this.bankName;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public static class Builder {
        private String orderNo;
        private String bankName;
        private String orgName;

        public static Builder fromJsonObject(JSONObject jsonObject) {
            Builder builder = new Builder();
            if (jsonObject == null) {
                return builder;
            }
            if (jsonObject.has("orderNo")) {
                builder.orderNo(jsonObject.getString("orderNo"));
            }
            if (jsonObject.has("bankName")) {
                builder.bankName(jsonObject.getString("bankName"));
            }
            if (jsonObject.has("orgName")) {
                builder.orgName(jsonObject.getString("orgName"));
            }
            return builder;
        }

        public Builder orderNo(String orderNo) {
            this.orderNo = orderNo;
            return this;
        }

        public Builder orgName(String orgName) {
            this.orgName = orgName;
            return this;
        }

        public Builder bankName(String bankName) {
            this.bankName = bankName;
            return this;
        }

        public CancelPaymentRequest build() {
            return new CancelPaymentRequest(this);
        }
    }
}

