/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.mq.rabbitMQ;

import com.af.v4.system.common.core.proxy.logic.ILogicServiceProxy;
import com.af.v4.system.common.core.utils.uuid.IdUtils;
import com.af.v4.system.common.mq.rabbitMQ.MultiRabbitConnectionManager;
import com.af.v4.system.common.mq.rabbitMQ.MultiRabbitProperties;
import com.rabbitmq.client.Channel;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.RabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistry;
import org.springframework.amqp.rabbit.listener.api.ChannelAwareMessageListener;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@ConditionalOnProperty(prefix="rabbitmq", name={"enabled"}, havingValue="true")
public class UnifiedMessageProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnifiedMessageProcessor.class);
    private final MultiRabbitProperties properties;
    private final MultiRabbitConnectionManager connectionManager;
    private final RabbitListenerEndpointRegistry registry;
    private final ILogicServiceProxy logicService;
    private final AtomicInteger listenerCounter = new AtomicInteger(0);

    public UnifiedMessageProcessor(MultiRabbitProperties properties, MultiRabbitConnectionManager connectionManager, RabbitListenerEndpointRegistry registry, ILogicServiceProxy logicService) {
        this.properties = properties;
        this.connectionManager = connectionManager;
        this.registry = registry;
        this.logicService = logicService;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void initializeRabbitListeners() {
        if (this.properties.getConnections() == null || this.properties.getConnections().isEmpty()) {
            LOGGER.info("[RabbitMQ] \u672a\u914d\u7f6e\u4efb\u4f55RabbitMQ\u8fde\u63a5\uff0c\u8df3\u8fc7\u521d\u59cb\u5316");
            return;
        }
        LOGGER.info("[RabbitMQ] \u5f00\u59cb\u52a8\u6001\u6ce8\u518cRabbitMQ\u6d88\u606f\u76d1\u542c\u5668...");
        int totalListeners = 0;
        for (Map.Entry<String, MultiRabbitProperties.ConnectionConfig> entry : this.properties.getConnections().entrySet()) {
            String connectionName = entry.getKey();
            MultiRabbitProperties.ConnectionConfig config = entry.getValue();
            if (!Boolean.TRUE.equals(config.getEnabled()) || config.getListenQueues().isEmpty()) continue;
            for (String queueName : config.getListenQueues()) {
                if (!StringUtils.hasText((String)queueName)) continue;
                this.registerDynamicListener(connectionName, queueName);
                ++totalListeners;
            }
            LOGGER.info("[RabbitMQ] \u8fde\u63a5 [{}] \u6ce8\u518c\u4e86 {} \u4e2a\u961f\u5217\u76d1\u542c\u5668", (Object)connectionName, (Object)config.getListenQueues().size());
        }
        LOGGER.info("\u52a8\u6001\u6ce8\u518cRabbitMQ\u76d1\u542c\u5668\u5b8c\u6210\uff0c\u5171\u6ce8\u518c {} \u4e2a\u76d1\u542c\u5668", (Object)totalListeners);
    }

    private void registerDynamicListener(String connectionName, String queueName) {
        try {
            if (!this.connectionManager.hasConnection(connectionName)) {
                LOGGER.error("[RabbitMQ] \u8fde\u63a5 [{}] \u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u6ce8\u518c\u961f\u5217 [{}] \u7684\u76d1\u542c\u5668", (Object)connectionName, (Object)queueName);
                return;
            }
            SimpleRabbitListenerEndpoint endpoint = new SimpleRabbitListenerEndpoint();
            endpoint.setId(this.generateListenerId(connectionName, queueName));
            endpoint.setQueueNames(new String[]{queueName});
            endpoint.setMessageListener((MessageListener)((ChannelAwareMessageListener)(message, channel) -> this.processUnifiedMessage(message, channel, connectionName, queueName)));
            SimpleRabbitListenerContainerFactory containerFactory = this.connectionManager.getContainerFactory(connectionName);
            this.registry.registerListenerContainer((RabbitListenerEndpoint)endpoint, (RabbitListenerContainerFactory)containerFactory, true);
            LOGGER.info("[RabbitMQ] \u6210\u529f\u6ce8\u518c\u76d1\u542c\u5668: \u8fde\u63a5=[{}], \u961f\u5217=[{}], ID=[{}]", new Object[]{connectionName, queueName, endpoint.getId()});
        }
        catch (Exception e) {
            LOGGER.error("[RabbitMQ] \u6ce8\u518c\u76d1\u542c\u5668\u5931\u8d25: \u8fde\u63a5=[{}], \u961f\u5217=[{}]", new Object[]{connectionName, queueName, e});
        }
    }

    private void processUnifiedMessage(Message message, Channel channel, String connectionName, String queueName) {
        String messageId = IdUtils.fastSimpleUUID();
        long deliveryTag = message.getMessageProperties().getDeliveryTag();
        LOGGER.info("[RabbitMQ] \u63a5\u6536\u6d88\u606f: \u8fde\u63a5=[{}], \u961f\u5217=[{}], \u6d88\u606fID=[{}], \u6295\u9012\u6807\u7b7e=[{}]", new Object[]{connectionName, queueName, messageId, deliveryTag});
        try {
            JSONObject data = this.buildMessageData(message, connectionName, queueName, messageId);
            LOGGER.debug("[RabbitMQ] \u8c03\u7528Logic\u5904\u7406\u6d88\u606f: logic=[{}], \u8fde\u63a5=[{}], \u961f\u5217=[{}]", new Object[]{queueName, connectionName, queueName});
            Object result = this.logicService.run(queueName, data.toString());
            channel.basicAck(deliveryTag, false);
            LOGGER.info("[RabbitMQ] \u6d88\u606f\u5904\u7406\u6210\u529f\u5e76\u5df2\u786e\u8ba4: \u8fde\u63a5=[{}], \u961f\u5217=[{}], Logic=[{}]", new Object[]{connectionName, queueName, queueName});
        }
        catch (Exception e) {
            LOGGER.error("[RabbitMQ] \u6d88\u606f\u5904\u7406\u5931\u8d25: \u961f\u5217=[{}], Logic=[{}], \u9519\u8bef: {}", new Object[]{queueName, queueName, e.getMessage(), e});
            try {
                boolean requeue = this.shouldRequeueOnError(e);
                channel.basicNack(deliveryTag, false, requeue);
                LOGGER.warn("[RabbitMQ] \u6d88\u606f\u5df2\u62d2\u7edd: \u961f\u5217=[{}], \u91cd\u65b0\u5165\u961f=[{}]", (Object)queueName, (Object)requeue);
            }
            catch (Exception ackException) {
                LOGGER.error("[RabbitMQ] \u6d88\u606f\u786e\u8ba4\u64cd\u4f5c\u5931\u8d25: \u961f\u5217=[{}]", (Object)queueName, (Object)ackException);
            }
        }
    }

    private boolean shouldRequeueOnError(Exception e) {
        return false;
    }

    private JSONObject buildMessageData(Message message, String connectionName, String queueName, String messageId) {
        JSONObject data = new JSONObject();
        data.put("messageId", (Object)messageId);
        data.put("connectionName", (Object)connectionName);
        data.put("queueName", (Object)queueName);
        data.put("message", (Object)new String(message.getBody()));
        data.put("timestamp", System.currentTimeMillis());
        if (message.getMessageProperties() != null) {
            data.put("exchange", (Object)message.getMessageProperties().getReceivedExchange());
            data.put("routingKey", (Object)message.getMessageProperties().getReceivedRoutingKey());
            data.put("contentType", (Object)message.getMessageProperties().getContentType());
            if (message.getMessageProperties().getHeaders() != null) {
                data.put("headers", (Object)new JSONObject(message.getMessageProperties().getHeaders()));
            }
        }
        return data;
    }

    private String generateListenerId(String connectionName, String queueName) {
        return String.format("rabbit-listener-%s-%s-%d", connectionName, queueName.replace(".", "_"), this.listenerCounter.incrementAndGet());
    }
}

