/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.mq.rabbitMQ;

import com.af.v4.system.common.mq.rabbitMQ.MultiRabbitProperties;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@ConditionalOnProperty(prefix="rabbitmq", name={"enabled"}, havingValue="true")
public class MultiRabbitConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiRabbitConnectionManager.class);
    private final MultiRabbitProperties properties;
    private final MessageConverter messageConverter;
    private final Map<String, ConnectionFactory> connectionFactories = new ConcurrentHashMap<String, ConnectionFactory>();
    private final Map<String, RabbitTemplate> rabbitTemplates = new ConcurrentHashMap<String, RabbitTemplate>();
    private final Map<String, SimpleRabbitListenerContainerFactory> containerFactories = new ConcurrentHashMap<String, SimpleRabbitListenerContainerFactory>();

    public MultiRabbitConnectionManager(MultiRabbitProperties properties) {
        this.properties = properties;
        this.messageConverter = new Jackson2JsonMessageConverter();
    }

    @PostConstruct
    public void initConnections() {
        if (this.properties.getConnections() == null || this.properties.getConnections().isEmpty()) {
            LOGGER.debug("[RabbitMQ] \u672a\u914d\u7f6e\u4efb\u4f55\u8fde\u63a5\uff0c\u8df3\u8fc7\u521d\u59cb\u5316");
            return;
        }
        this.properties.getConnections().forEach((connectionName, config) -> {
            if (Boolean.TRUE.equals(config.getEnabled())) {
                try {
                    this.initSingleConnection((String)connectionName, (MultiRabbitProperties.ConnectionConfig)config);
                    LOGGER.debug("[RabbitMQ] \u8fde\u63a5 [{}] \u521d\u59cb\u5316\u6210\u529f: {}:{}", new Object[]{connectionName, config.getHost(), config.getPort()});
                }
                catch (Exception e) {
                    LOGGER.error("[RabbitMQ] \u8fde\u63a5 [{}] \u521d\u59cb\u5316\u5931\u8d25: {}:{}", new Object[]{connectionName, config.getHost(), config.getPort(), e});
                }
            } else {
                LOGGER.debug("[RabbitMQ] \u8fde\u63a5 [{}] \u5df2\u7981\u7528\uff0c\u8df3\u8fc7\u521d\u59cb\u5316", connectionName);
            }
        });
        LOGGER.info("[RabbitMQ] \u521d\u59cb\u5316\u5b8c\u6210\uff0c\u5171 {} \u4e2a\u8fde\u63a5", (Object)this.connectionFactories.size());
    }

    private void initSingleConnection(String connectionName, MultiRabbitProperties.ConnectionConfig config) {
        this.validateRequiredConfig(connectionName, config);
        ConnectionFactory connectionFactory = this.createConnectionFactory(config);
        this.connectionFactories.put(connectionName, connectionFactory);
        RabbitTemplate rabbitTemplate = this.createRabbitTemplate(connectionFactory);
        this.rabbitTemplates.put(connectionName, rabbitTemplate);
        SimpleRabbitListenerContainerFactory containerFactory = this.createContainerFactory(connectionFactory, config);
        this.containerFactories.put(connectionName, containerFactory);
    }

    private void validateRequiredConfig(String connectionName, MultiRabbitProperties.ConnectionConfig config) {
        if (!StringUtils.hasText((String)config.getHost())) {
            throw new IllegalArgumentException("RabbitMQ\u8fde\u63a5 [" + connectionName + "] \u7f3a\u5c11\u5fc5\u586b\u53c2\u6570: host");
        }
        if (!StringUtils.hasText((String)config.getUsername())) {
            throw new IllegalArgumentException("RabbitMQ\u8fde\u63a5 [" + connectionName + "] \u7f3a\u5c11\u5fc5\u586b\u53c2\u6570: username");
        }
        if (!StringUtils.hasText((String)config.getPassword())) {
            throw new IllegalArgumentException("RabbitMQ\u8fde\u63a5 [" + connectionName + "] \u7f3a\u5c11\u5fc5\u586b\u53c2\u6570: password");
        }
    }

    private ConnectionFactory createConnectionFactory(MultiRabbitProperties.ConnectionConfig config) {
        CachingConnectionFactory factory = new CachingConnectionFactory();
        factory.setHost(config.getHost());
        factory.setPort(config.getPort().intValue());
        factory.setUsername(config.getUsername());
        factory.setPassword(config.getPassword());
        if (StringUtils.hasText((String)config.getVirtualHost())) {
            factory.setVirtualHost(config.getVirtualHost());
        }
        factory.setConnectionTimeout(config.getConnectionTimeout().intValue());
        factory.setRequestedHeartBeat(config.getRequestedHeartbeat().intValue());
        factory.getRabbitConnectionFactory().setAutomaticRecoveryEnabled(true);
        factory.getRabbitConnectionFactory().setNetworkRecoveryInterval(5000);
        factory.getRabbitConnectionFactory().setTopologyRecoveryEnabled(true);
        factory.setChannelCacheSize(25);
        factory.setConnectionCacheSize(10);
        return factory;
    }

    private RabbitTemplate createRabbitTemplate(ConnectionFactory connectionFactory) {
        RabbitTemplate template = new RabbitTemplate(connectionFactory);
        template.setMessageConverter(this.messageConverter);
        return template;
    }

    private SimpleRabbitListenerContainerFactory createContainerFactory(ConnectionFactory connectionFactory, MultiRabbitProperties.ConnectionConfig config) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setMessageConverter(this.messageConverter);
        factory.setAcknowledgeMode(AcknowledgeMode.MANUAL);
        factory.setConcurrentConsumers(config.getConcurrentConsumers());
        factory.setMaxConcurrentConsumers(config.getMaxConcurrentConsumers());
        factory.setPrefetchCount(config.getPrefetchCount());
        factory.setTaskExecutor((Executor)new SimpleAsyncTaskExecutor("rabbit-" + this.hashCode() + "-"));
        factory.setErrorHandler(t -> LOGGER.error("[RabbitMQ] \u6d88\u606f\u5904\u7406\u51fa\u9519", t));
        return factory;
    }

    public ConnectionFactory getConnectionFactory(String connectionName) {
        ConnectionFactory factory = this.connectionFactories.get(connectionName);
        if (factory == null) {
            throw new IllegalArgumentException("RabbitMQ\u8fde\u63a5\u4e0d\u5b58\u5728: " + connectionName);
        }
        return factory;
    }

    public RabbitTemplate getRabbitTemplate(String connectionName) {
        RabbitTemplate template = this.rabbitTemplates.get(connectionName);
        if (template == null) {
            throw new IllegalArgumentException("RabbitMQ\u8fde\u63a5\u4e0d\u5b58\u5728: " + connectionName);
        }
        return template;
    }

    public SimpleRabbitListenerContainerFactory getContainerFactory(String connectionName) {
        SimpleRabbitListenerContainerFactory factory = this.containerFactories.get(connectionName);
        if (factory == null) {
            throw new IllegalArgumentException("RabbitMQ\u8fde\u63a5\u4e0d\u5b58\u5728: " + connectionName);
        }
        return factory;
    }

    public Map<String, ConnectionFactory> getAllConnectionFactories() {
        return new HashMap<String, ConnectionFactory>(this.connectionFactories);
    }

    public Map<String, RabbitTemplate> getAllRabbitTemplates() {
        return new HashMap<String, RabbitTemplate>(this.rabbitTemplates);
    }

    public boolean hasConnection(String connectionName) {
        return this.connectionFactories.containsKey(connectionName);
    }
}

