/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.log.service;

import com.af.v4.system.api.model.LoginUser;
import com.af.v4.system.common.core.enums.EnvType;
import com.af.v4.system.common.core.exception.LogicException;
import com.af.v4.system.common.core.proxy.liuli.ILiuLiMonitorServiceProxy;
import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.core.utils.ServletUtils;
import com.af.v4.system.common.core.utils.StringUtils;
import com.af.v4.system.common.core.utils.ip.IpUtils;
import com.af.v4.system.common.log.enums.BusinessStatus;
import com.af.v4.system.common.log.service.AsyncLogService;
import com.af.v4.system.common.security.utils.SecurityUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.function.Consumer;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class LogResolveService {
    private final ApplicationService applicationService;
    private final AsyncLogService asyncLogService;
    private final ILiuLiMonitorServiceProxy liuLiMonitorService;

    public LogResolveService(ApplicationService applicationService, AsyncLogService logService, ILiuLiMonitorServiceProxy liuLiMonitorService) {
        this.applicationService = applicationService;
        this.asyncLogService = logService;
        this.liuLiMonitorService = liuLiMonitorService;
    }

    public void resolveLog(String className, String methodName, String businessType, String title, String operatorType, String operParams, long costTime, Throwable e) {
        this.resolveLog(className, methodName, businessType, title, operatorType, operParams, costTime, e, null);
    }

    public void resolveLog(String className, String methodName, String businessType, String title, String operatorType, String operParams, long costTime, Throwable e, Consumer<JSONObject> appendOperLogConsumer) {
        LogicException ex;
        HttpServletRequest request;
        String username;
        if (this.applicationService.getEnvType() == EnvType.LOCAL) {
            return;
        }
        LoginUser loginUser = SecurityUtils.getLoginUser();
        if (loginUser == null && e == null) {
            return;
        }
        JSONObject operLog = new JSONObject();
        operLog.put("f_oper_ip", (Object)IpUtils.getIpAddr());
        if (e == null) {
            operLog.put("f_status", BusinessStatus.SUCCESS.ordinal());
        } else {
            operLog.put("f_status", BusinessStatus.FAIL.ordinal());
            if (e instanceof LogicException) {
                LogicException logicException = (LogicException)e;
                operLog.put("f_method", (Object)logicException.getLogicPath());
                operLog.put("f_title", (Object)("Logic\u5f02\u5e38:" + logicException.getTitle()));
                operLog.put("f_oper_param", (Object)logicException.getLogicParams());
                operLog.put("f_error_msg", (Object)logicException.getStack());
            } else {
                operLog.put("f_error_msg", (Object)e.getMessage());
            }
        }
        if (loginUser != null && StringUtils.isNotBlank((CharSequence)(username = loginUser.getUsername()))) {
            operLog.put("f_oper_name", (Object)username);
        }
        if (!operLog.has("f_method")) {
            operLog.put("f_method", (Object)(className + "." + methodName + "()"));
        }
        if ((request = ServletUtils.getRequest()) != null) {
            operLog.put("f_oper_url", (Object)StringUtils.substring((String)request.getRequestURI(), (int)0, (int)255));
            operLog.put("f_request_method", (Object)request.getMethod());
        }
        if (!operLog.has("f_business_type")) {
            operLog.put("f_business_type", (Object)businessType);
        }
        if (!operLog.has("f_title")) {
            operLog.put("f_title", (Object)title);
        }
        if (!operLog.has("f_operator_type")) {
            operLog.put("f_operator_type", (Object)operatorType);
        }
        if (!operLog.has("f_oper_param") && operParams != null) {
            operLog.put("f_oper_param", (Object)operParams);
        }
        operLog.put("f_cost_time", costTime);
        if (appendOperLogConsumer != null) {
            appendOperLogConsumer.accept(operLog);
        }
        if (operLog.has("f_error_msg")) {
            operLog.put("f_error_msg", (Object)StringUtils.substring((String)operLog.getString("f_error_msg").replace("'", "''"), (int)0, (int)8000));
        }
        if (operLog.has("f_oper_param")) {
            operLog.put("f_oper_param", (Object)StringUtils.substring((String)operLog.getString("f_oper_param").replace("'", "''"), (int)0, (int)8000));
        }
        if (operLog.has("f_title")) {
            operLog.put("f_title", (Object)StringUtils.substring((String)operLog.getString("f_title").replace("'", "''"), (int)0, (int)300));
        }
        if (operLog.has("f_json_result")) {
            operLog.put("f_json_result", (Object)StringUtils.substring((String)operLog.getString("f_json_result").replace("'", "''"), (int)0, (int)2000));
        }
        this.asyncLogService.saveSysLog(operLog.toString());
        if (e instanceof LogicException && (ex = (LogicException)e).getLogicName().equals("uploadErrorLog")) {
            return;
        }
        if (e != null) {
            this.liuLiMonitorService.uploadLogicErrorLog(operLog);
        }
    }
}

