/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.log.aspect;

import com.af.v4.system.common.core.utils.ServletUtils;
import com.af.v4.system.common.core.utils.StringUtils;
import com.af.v4.system.common.log.annotation.Log;
import com.af.v4.system.common.log.filter.PropertyPreExcludeFilter;
import com.af.v4.system.common.log.service.LogResolveService;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.Filter;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Component
public class LogAspect {
    public static final String[] EXCLUDE_PROPERTIES = new String[]{"password", "oldPassword", "newPassword", "confirmPassword"};
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    private final LogResolveService logResolveService;

    public LogAspect(LogResolveService logResolveService) {
        this.logResolveService = logResolveService;
    }

    @Around(value="@annotation(controllerLog)")
    public Object around(ProceedingJoinPoint joinPoint, Log controllerLog) throws Throwable {
        long beginTime = System.currentTimeMillis();
        try {
            Object result = joinPoint.proceed();
            long endTime = System.currentTimeMillis();
            this.handleLog((JoinPoint)joinPoint, controllerLog, null, result, endTime - beginTime);
            return result;
        }
        catch (Throwable t) {
            long endTime = System.currentTimeMillis();
            this.handleLog((JoinPoint)joinPoint, controllerLog, t, null, endTime - beginTime);
            throw t;
        }
    }

    protected void handleLog(JoinPoint joinPoint, Log controllerLog, Throwable e, Object jsonResult, long costTime) {
        this.logResolveService.resolveLog(joinPoint.getTarget().getClass().getName(), joinPoint.getSignature().getName(), controllerLog.businessType().name(), controllerLog.title(), controllerLog.operatorType().name(), null, costTime, e, jsonObject -> {
            HttpServletRequest request = ServletUtils.getRequest();
            if (request != null) {
                this.getControllerMethodDescription(joinPoint, controllerLog, (JSONObject)jsonObject, jsonResult);
            }
        });
    }

    public void getControllerMethodDescription(JoinPoint joinPoint, Log log, JSONObject operLog, Object jsonResult) {
        if (log.isSaveRequestData() && !operLog.has("f_oper_param")) {
            this.setRequestValue(joinPoint, operLog, log.excludeParamNames());
        }
        if (log.isSaveResponseData() && StringUtils.isNotNull((Object)jsonResult) && !operLog.has("f_json_result")) {
            operLog.put("f_json_result", (Object)StringUtils.substring((String)jsonResult.toString(), (int)0, (int)2000));
        }
    }

    private void setRequestValue(JoinPoint joinPoint, JSONObject operLog, String[] excludeParamNames) {
        Map paramsMap = ServletUtils.getParamMap((ServletRequest)ServletUtils.getRequest());
        String requestMethod = operLog.optString("f_request_method", null);
        if (requestMethod != null && StringUtils.isEmpty((Map)paramsMap) && StringUtils.equalsAny((CharSequence)requestMethod, (CharSequence[])new CharSequence[]{HttpMethod.PUT.name(), HttpMethod.POST.name(), HttpMethod.DELETE.name()})) {
            String params = this.argsArrayToString(joinPoint.getArgs(), excludeParamNames);
            operLog.put("f_oper_param", (Object)StringUtils.substring((String)params, (int)0, (int)2000));
        } else {
            operLog.put("f_oper_param", (Object)StringUtils.substring((String)JSON.toJSONString((Object)paramsMap, (Filter)this.excludePropertyPreFilter(excludeParamNames), (JSONWriter.Feature[])new JSONWriter.Feature[0]), (int)0, (int)2000));
        }
    }

    private String argsArrayToString(Object[] paramsArray, String[] excludeParamNames) {
        StringBuilder params = new StringBuilder();
        if (paramsArray != null) {
            for (Object o : paramsArray) {
                if (!StringUtils.isNotNull((Object)o) || this.isFilterObject(o)) continue;
                try {
                    String jsonObj = JSON.toJSONString((Object)o, (Filter)this.excludePropertyPreFilter(excludeParamNames), (JSONWriter.Feature[])new JSONWriter.Feature[0]);
                    params.append(jsonObj).append(" ");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return params.toString().trim();
    }

    public PropertyPreExcludeFilter excludePropertyPreFilter(String[] excludeParamNames) {
        return new PropertyPreExcludeFilter().addExcludes((String[])ArrayUtils.addAll((Object[])EXCLUDE_PROPERTIES, (Object[])excludeParamNames));
    }

    public boolean isFilterObject(Object o) {
        Map map;
        Iterator iterator;
        Class<?> clazz = o.getClass();
        if (clazz.isArray()) {
            return clazz.getComponentType().isAssignableFrom(MultipartFile.class);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Collection collection = (Collection)o;
            Iterator iterator2 = collection.iterator();
            if (iterator2.hasNext()) {
                Object value = iterator2.next();
                return value instanceof MultipartFile;
            }
        } else if (Map.class.isAssignableFrom(clazz) && (iterator = (map = (Map)o).entrySet().iterator()).hasNext()) {
            Map.Entry value;
            Map.Entry entry = value = iterator.next();
            return entry.getValue() instanceof MultipartFile;
        }
        return o instanceof MultipartFile || o instanceof HttpServletRequest || o instanceof HttpServletResponse || o instanceof BindingResult;
    }
}

