/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.dict.service;

import com.af.v4.system.common.core.proxy.liuli.ILiuLiDictServiceProxy;
import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class LiuLiDictService
implements ILiuLiDictServiceProxy {
    private final LiuLiConfigService liuLiConfigService;

    public LiuLiDictService(LiuLiConfigService liuLiConfigService) {
        this.liuLiConfigService = liuLiConfigService;
    }

    public String getDictValue(String dictType, String dictLabel) {
        return this.getAllDictByDictType(dictType, 1).get(dictLabel);
    }

    public String getDictLabel(String dictType, String dictValue) {
        try {
            return this.getAllDictByDictType(dictType).get(dictValue);
        }
        catch (Exception e) {
            return dictValue;
        }
    }

    public Map<String, String> getDictValueMap(String dictType) {
        return this.getAllDictByDictType(dictType, 0);
    }

    public Map<String, String> getAllDictByDictType(String dictType, Integer type) {
        JSONArray list = this.liuLiConfigService.get(dictType, true).optJSONArray("value", new JSONArray());
        HashMap<String, String> dictMap = new HashMap<String, String>(list.length());
        list.forEach(item -> {
            JSONObject itemObj = (JSONObject)item;
            if (type == 0) {
                dictMap.put(itemObj.get("value").toString(), itemObj.get("label").toString());
            } else {
                dictMap.put(itemObj.get("label").toString(), itemObj.get("value").toString());
            }
        });
        return dictMap;
    }

    public Map<String, String> getAllDictByDictType(String dictType) {
        return this.getAllDictByDictType(dictType, 0);
    }
}

