package com.af.v4.system.common.liuli.application.service;

import com.af.v4.system.api.model.LoginUser;
import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.core.utils.StringUtils;
import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.datasource.enums.DbType;
import com.af.v4.system.common.security.utils.SecurityUtils;
import org.json.JSONObject;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

/**
 * 琉璃应用信息服务
 */
@Primary
@Component
public final class GlazeApplicationService extends ApplicationService {

    /**
     * 获取当前数据源类型
     *
     * @return 数据源类型
     */
    public static DbType getDbType() {
        return DynamicDataSource.getDbType();
    }

    /**
     * 从登录人中获取分公司名称,如果获取不到则返回租户名称
     *
     * @return 分公司名称
     */
    public String getOrgName() {
        LoginUser loginUser = SecurityUtils.getLoginUser();
        if (loginUser != null) {
            String userTenantName = loginUser.getTenantName();
            if (!StringUtils.isEmpty(userTenantName)) {
                return userTenantName;
            }
        }
        return getTenantName();
    }

    @Override
    public JSONObject getValues() {
        JSONObject values = super.getValues();
        values.put("orgName", getOrgName());
        values.put("dbType", getDbType());
        return values;
    }
}
