/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.business.service;

import com.af.v4.system.api.RemoteLiuLiService;
import com.af.v4.system.api.factory.DynamicFeignClientFactory;
import com.af.v4.system.common.core.enums.EnvType;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.proxy.logic.ILogicServiceProxy;
import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.core.utils.StringUtils;
import com.af.v4.system.common.liuli.api.LiuLiApi;
import com.af.v4.system.common.liuli.config.LiuLiClientConfig;
import com.af.v4.system.common.liuli.utils.enums.LiuLiClientOperationalModeEnum;
import com.af.v4.system.common.plugins.http.RestAsyncTools;
import com.af.v4.system.common.plugins.http.config.HttpLogSuppressor;
import com.af.v4.system.common.plugins.http.core.response.AsyncResponse;
import com.af.v4.system.common.plugins.http.core.response.EmptyAsyncResponse;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LiuLiBusinessService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LiuLiBusinessService.class);
    private final ApplicationService applicationService;
    private final LiuLiClientConfig liuLiClientConfig;
    private final DynamicFeignClientFactory dynamicFeignClientFactory;
    private final LiuLiApi liuLiApi;

    public LiuLiBusinessService(ApplicationService applicationService, LiuLiClientConfig liuLiClientConfig, DynamicFeignClientFactory dynamicFeignClientFactory, LiuLiApi liuLiApi) {
        this.applicationService = applicationService;
        this.liuLiClientConfig = liuLiClientConfig;
        this.dynamicFeignClientFactory = dynamicFeignClientFactory;
        this.liuLiApi = liuLiApi;
    }

    public void uploadRuntimeErrorRecord(JSONObject runtimeErrorRecord) {
        if (this.liuLiClientConfig.getLiuLiClientOperationalMode() == LiuLiClientOperationalModeEnum.OFFLINE) {
            return;
        }
        EnvType envType = this.applicationService.getEnvType();
        if (envType == EnvType.LOCAL) {
            return;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tenantUUID", (Object)this.applicationService.getTenantName());
        jsonObject.put("applicationName", (Object)this.applicationService.getApplicationName());
        jsonObject.put("applicationVersion", (Object)ApplicationService.getAppVersion());
        jsonObject.put("coreVersion", (Object)ApplicationService.getSystemV4Version());
        jsonObject.put("osType", (Object)ApplicationService.getOSType());
        jsonObject.put("environment", (Object)this.applicationService.getEnvType().getValue());
        if (runtimeErrorRecord.has("errorMsg")) {
            jsonObject.put("errorMsg", (Object)StringUtils.substring((String)runtimeErrorRecord.getString("errorMsg").replace("'", "''"), (int)0, (int)8000));
        }
        if (runtimeErrorRecord.has("businessTitle")) {
            jsonObject.put("businessTitle", (Object)StringUtils.substring((String)runtimeErrorRecord.getString("businessTitle").replace("'", "''"), (int)0, (int)300));
        }
        HttpLogSuppressor.run(() -> {
            if (this.applicationService.getApplicationName().equals("af-liuli")) {
                try {
                    ((ILogicServiceProxy)SpringUtils.getBean(ILogicServiceProxy.class)).run("uploadRuntimeErrorRecord", jsonObject);
                }
                catch (ServiceException serviceException) {}
            } else if (this.liuLiClientConfig.getLiuLiClientOperationalMode() == LiuLiClientOperationalModeEnum.INTRANET) {
                RemoteLiuLiService remoteLiuLiService = (RemoteLiuLiService)this.dynamicFeignClientFactory.getFeignClient(RemoteLiuLiService.class, "af-liuli");
                remoteLiuLiService.uploadRuntimeErrorRecord(jsonObject.toString(), "inner");
            } else {
                RestAsyncTools.post((String)this.liuLiApi.getUploadRuntimeErrorRecordUrl(), (String)jsonObject.toString(), null, (AsyncResponse)new EmptyAsyncResponse());
            }
        });
    }
}

