package com.af.v4.system.common.liuli.utils.enums;

import java.util.stream.Stream;

/**
 * 琉璃客户端运行模式
 *
 * @author Mr.river
 */
public enum LiuLiClientOperationalModeEnum {
    // 常规
    NORMAL("normal"),
    // 内网
    INTRANET("intranet"),
    // 离线
    OFFLINE("offline");

    private final String value;

    LiuLiClientOperationalModeEnum(String value) {
        this.value = value;
    }

    public static LiuLiClientOperationalModeEnum toType(String value) {
        return Stream.of(LiuLiClientOperationalModeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value) {
        return toType(value) != null;
    }

    public String getValue() {
        return value;
    }
}
