/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.dialect;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.jpa.dialect.MyClickHouseDialect;
import com.af.v4.system.common.jpa.dialect.MyOpenGaussDialect;
import com.af.v4.system.common.jpa.dialect.Oracle11Dialect;
import com.af.v4.system.common.jpa.dialect.SQLServer2008Dialect;
import com.af.v4.system.common.jpa.dialect.SQLServer2016Dialect;
import org.hibernate.dialect.Database;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmDialect;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolver;

public final class MyDialectResolver
implements DialectResolver {
    public Dialect resolveDialect(DialectResolutionInfo info) {
        if (info.getDatabaseName().contains("ClickHouse")) {
            return new MyClickHouseDialect();
        }
        if (info.getDatabaseName().contains("Dm")) {
            return new DmDialect();
        }
        for (Database database : Database.values()) {
            if (database == Database.SQLSERVER) {
                if (info.getDatabaseMajorVersion() <= 10) {
                    return new SQLServer2008Dialect();
                }
                return new SQLServer2016Dialect();
            }
            if (database == Database.ORACLE) {
                if (!info.getDatabaseVersion().startsWith("Oracle Database")) continue;
                return new Oracle11Dialect();
            }
            if (database == Database.POSTGRESQL) {
                if (!info.getDatabaseMetadata().toString().contains("org.opengauss")) continue;
                return new MyOpenGaussDialect();
            }
            if (!database.matchesResolutionInfo(info)) continue;
            return database.createDialect(info);
        }
        throw new ServiceException("\u6570\u636e\u6e90[" + DynamicDataSource.getDataSource() + "]\u65b9\u8a00\u4e0d\u652f\u6301\uff01", Integer.valueOf(506));
    }
}

