package com.af.v4.system.common.jpa.enums;

import java.util.stream.Stream;

/**
 * ID主键自增类型
 */
public enum IDTypeEnum {
    ID_GUID("ID_GUID"),
    ID_SEQ("ID_SEQ"),
    ID_AUTO("ID_AUTO"),
    ID_ASSIGNED("ID_ASSIGNED"),
    ID_FOREIGNER("ID_FOREIGNER");

    private final String value;

    IDTypeEnum(String value) {
        this.value = value;
    }

    public static IDTypeEnum toType(String value) {
        return Stream.of(IDTypeEnum.values())
                .filter(p -> p.value.contains(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value) {
        return toType(value) != null;
    }

    public String getValue() {
        return value;
    }
}
