/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.transformer;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TemporalAccessorUtil;
import com.af.v4.system.common.jpa.service.MetaDataService;
import com.af.v4.system.common.jpa.utils.ClobUtil;
import com.af.v4.system.common.plugins.security.SensitiveDataEnhancer;
import com.af.v4.system.common.plugins.security.SubstitutionCipherUtil;
import com.af.v4.system.common.security.auth.AuthUtil;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.sql.Clob;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Map;
import org.hibernate.query.TupleTransformer;
import org.json.JSONObject;
import org.json.JSONParserConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardAliasTransformer
implements TupleTransformer<JSONObject> {
    private static final Logger log = LoggerFactory.getLogger(StandardAliasTransformer.class);
    public static final StandardAliasTransformer INSTANCE = new StandardAliasTransformer();

    private StandardAliasTransformer() {
    }

    protected static void runTrans(Object obj, Object[] tuple, String[] aliases) {
        for (int i = 0; i < aliases.length; ++i) {
            Object key;
            Object value;
            String alias = aliases[i];
            Object object = value = tuple[i];
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BigDecimal.class, Date.class, TemporalAccessor.class, Clob.class}, (Object)object, n)) {
                case -1: {
                    value = JSONObject.NULL;
                    break;
                }
                case 0: {
                    BigDecimal bigDecimal = (BigDecimal)object;
                    if (!StandardAliasTransformer.isIntegerValue(bigDecimal)) break;
                    long longValue = bigDecimal.longValue();
                    if (longValue < Integer.MAX_VALUE) {
                        value = (int)longValue;
                        break;
                    }
                    value = longValue;
                    break;
                }
                case 1: {
                    Date date = (Date)object;
                    value = DateUtil.formatDateTime((Date)date);
                    break;
                }
                case 2: {
                    TemporalAccessor temporalAccessor = (TemporalAccessor)object;
                    value = TemporalAccessorUtil.format((TemporalAccessor)temporalAccessor, (String)"yyyy-MM-dd HH:mm:ss");
                    break;
                }
                case 3: {
                    Clob clob = (Clob)object;
                    value = ClobUtil.getClobString(clob);
                    break;
                }
            }
            if (value instanceof String) {
                String str = (String)value;
                String lowerAlias = alias != null ? alias.toLowerCase() : null;
                Map<String, String> maskMap = MetaDataService.getSensitiveMaskMap();
                if (lowerAlias != null && maskMap.containsKey(lowerAlias)) {
                    String plainText = str;
                    if (SubstitutionCipherUtil.isStrictCipher((String)str)) {
                        try {
                            plainText = SubstitutionCipherUtil.decrypt((String)str);
                        }
                        catch (Exception e) {
                            log.warn("\u654f\u611f\u5b57\u6bb5\u89e3\u5bc6\u5f02\u5e38: field={}, error={}", (Object)lowerAlias, (Object)e.getMessage());
                            plainText = null;
                        }
                    }
                    if (plainText != null) {
                        if (AuthUtil.hasSensitiveViewPermission((String)lowerAlias)) {
                            value = plainText;
                        } else {
                            String strategy = maskMap.get(lowerAlias);
                            value = SensitiveDataEnhancer.applyMaskingStrategy((String)lowerAlias, (String)plainText, (String)strategy);
                        }
                    }
                }
            }
            Object object2 = key = alias != null ? alias.toLowerCase() : "col" + i;
            if (obj instanceof JSONObject) {
                JSONObject object3 = (JSONObject)obj;
                object3.put((String)key, value);
                continue;
            }
            if (!(obj instanceof Map)) continue;
            Map objectMap = (Map)obj;
            objectMap.put(key, value);
        }
    }

    private static boolean isIntegerValue(BigDecimal bd) {
        return bd.stripTrailingZeros().scale() <= 0;
    }

    public JSONObject transformTuple(Object[] tuple, String[] aliases) {
        JSONObject result = new JSONObject(new JSONParserConfiguration().setOrdered(true));
        StandardAliasTransformer.runTrans(result, tuple, aliases);
        return result;
    }
}

