/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.sensitive;

import com.af.v4.system.common.jpa.sensitive.SensitiveDataClassifier;
import com.af.v4.system.common.jpa.sensitive.SensitiveDataProperties;
import com.af.v4.system.common.jpa.service.SqlService;
import com.af.v4.system.common.jpa.types.MetaData;
import com.af.v4.system.common.plugins.security.SensitiveDataEnhancer;
import com.af.v4.system.common.plugins.security.SubstitutionCipherUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SensitiveDataInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SensitiveDataInterceptor.class);
    public static final String CRYPTO_REF_ID_FIELD = "f_crypto_ref_id";
    private static final String PROTECTED_ROW_LOG = "[PROTECTED]";
    private static final String STATE_FIELD = "f_state";
    private static final String VALID_STATE = "valid";
    private static final String SOURCE_ENTITY_ID_FIELD = "source_entity_id";
    private static final String OLD_ID_FIELD = "old_id";
    private static final String QUERY_EXISTING_CRYPTO_DESCRIPTION = "\u67e5\u8be2\u73b0\u6709\u7684\u52a0\u5bc6\u6570\u636e";
    private static final String PAGE_SIZE_PARAM = "pageSize";
    private static final String PAGE_NO_PARAM = "pageNo";
    private static final String SINGLE_RESULT_SIZE = "1";
    private final SqlService sqlService;
    private final SensitiveDataProperties properties;
    private final SensitiveDataClassifier classifier = new SensitiveDataClassifier();

    public SensitiveDataInterceptor(SqlService sqlService, SensitiveDataProperties properties) {
        this.sqlService = sqlService;
        this.properties = properties;
    }

    public SensitiveDataEnhancer.SensitiveDataResult beforeSave(String entityName, JSONObject row, MetaData metaData) {
        if (!this.properties.isEnabled()) {
            return null;
        }
        if (metaData == null || !metaData.hasMetaAttributes()) {
            return null;
        }
        Set<String> sensitiveFields = metaData.getSensitiveFieldNames();
        if (sensitiveFields.isEmpty()) {
            return null;
        }
        try {
            Map<String, String> sameTableFields = sensitiveFields.stream().filter(fieldName -> entityName.equals(metaData.getSensitiveTargetTable((String)fieldName))).collect(Collectors.toMap(fieldName -> fieldName, fieldName -> fieldName));
            Map<String, String> crossTableFields = sensitiveFields.stream().filter(fieldName -> !entityName.equals(metaData.getSensitiveTargetTable((String)fieldName))).collect(Collectors.toMap(fieldName -> fieldName, metaData::getSensitiveTargetTable));
            if (!sameTableFields.isEmpty()) {
                this.processSameTableMode(entityName, row, sameTableFields, metaData);
            }
            SensitiveDataEnhancer.SensitiveDataResult crossTableResult = null;
            if (!crossTableFields.isEmpty()) {
                crossTableResult = this.processCrossTableMode(entityName, row, crossTableFields, metaData);
            }
            return crossTableResult;
        }
        catch (Exception e) {
            return this.handleProcessingError("beforeSave\u5904\u7406\u5931\u8d25", entityName, row, e);
        }
    }

    private boolean shouldProcessField(SensitiveDataClassifier.DataClassificationResult classification, String fieldName, Object originalValue, String context) {
        SensitiveDataClassifier.DataClassificationResult dataClassificationResult = classification;
        Objects.requireNonNull(dataClassificationResult);
        SensitiveDataClassifier.DataClassificationResult dataClassificationResult2 = dataClassificationResult;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SensitiveDataClassifier.DataClassificationResult.RawData.class, SensitiveDataClassifier.DataClassificationResult.AlreadyMasked.class, SensitiveDataClassifier.DataClassificationResult.AlreadyEncrypted.class, SensitiveDataClassifier.DataClassificationResult.NullValue.class, SensitiveDataClassifier.DataClassificationResult.Uncertain.class}, (Object)dataClassificationResult2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                SensitiveDataClassifier.DataClassificationResult.RawData rawData = (SensitiveDataClassifier.DataClassificationResult.RawData)dataClassificationResult2;
                log.debug("{} \u68c0\u6d4b\u5230\u539f\u59cb\u6570\u636e: {} = {} ({})", new Object[]{context, fieldName, originalValue, rawData.getDescription()});
                yield true;
            }
            case 1 -> {
                SensitiveDataClassifier.DataClassificationResult.AlreadyMasked alreadyMasked = (SensitiveDataClassifier.DataClassificationResult.AlreadyMasked)dataClassificationResult2;
                log.debug("{} \u5b57\u6bb5\u5df2\u8131\u654f\uff0c\u8df3\u8fc7: {} = {} ({})", new Object[]{context, fieldName, originalValue, alreadyMasked.getDescription()});
                yield false;
            }
            case 2 -> {
                SensitiveDataClassifier.DataClassificationResult.AlreadyEncrypted alreadyEncrypted = (SensitiveDataClassifier.DataClassificationResult.AlreadyEncrypted)dataClassificationResult2;
                log.debug("{} \u5b57\u6bb5\u5df2\u52a0\u5bc6\uff0c\u8df3\u8fc7: {} = {} ({})", new Object[]{context, fieldName, originalValue, alreadyEncrypted.getDescription()});
                yield false;
            }
            case 3 -> {
                SensitiveDataClassifier.DataClassificationResult.NullValue nullValue = (SensitiveDataClassifier.DataClassificationResult.NullValue)dataClassificationResult2;
                log.debug("{} \u5b57\u6bb5\u4e3a\u7a7a\u503c\uff0c\u8df3\u8fc7: {} = {} ({})", new Object[]{context, fieldName, originalValue, nullValue.getDescription()});
                yield false;
            }
            case 4 -> {
                SensitiveDataClassifier.DataClassificationResult.Uncertain uncertain = (SensitiveDataClassifier.DataClassificationResult.Uncertain)dataClassificationResult2;
                log.debug("{} \u5b57\u6bb5\u72b6\u6001\u4e0d\u786e\u5b9a\uff0c\u8df3\u8fc7: {} = {} ({})", new Object[]{context, fieldName, originalValue, uncertain.getDescription()});
                yield false;
            }
        };
    }

    private SensitiveDataEnhancer.SensitiveDataResult handleProcessingError(String operation, String entityName, JSONObject row, Exception e) {
        String rowInfo = row != null ? PROTECTED_ROW_LOG : "null";
        log.error("\u654f\u611f\u6570\u636e\u5904\u7406\u5931\u8d25\uff0c\u5c06\u8df3\u8fc7\u5904\u7406: {} -> {}, row={}", new Object[]{operation, entityName, rowInfo, e});
        return null;
    }

    private void handleFieldError(String operation, String fieldName, Exception e) {
        log.warn("{} \u5b57\u6bb5\u5904\u7406\u51fa\u9519: {} - {}", new Object[]{operation, fieldName, e.getMessage()});
        if (log.isDebugEnabled()) {
            log.debug("{} \u5b57\u6bb5\u5904\u7406\u8be6\u7ec6\u9519\u8bef\u4fe1\u606f:", (Object)operation, (Object)e);
        }
    }

    private void processSameTableMode(String entityName, JSONObject row, Map<String, String> sameTableFields, MetaData metaData) {
        log.debug("\u5904\u7406\u540c\u8868\u6a21\u5f0f: {}, \u5b57\u6bb5\u6570={}", (Object)entityName, (Object)sameTableFields.size());
        sameTableFields.keySet().stream().filter(fieldName -> Optional.ofNullable(row.opt(fieldName)).isPresent()).forEach(fieldName -> {
            Object originalValue = row.opt(fieldName);
            SensitiveDataClassifier.DataClassificationResult classification = this.classifier.classify((String)fieldName, originalValue);
            if (this.shouldProcessField(classification, (String)fieldName, originalValue, "\u540c\u8868\u6a21\u5f0f")) {
                this.processSingleField((String)fieldName, originalValue.toString(), row, metaData);
            }
        });
    }

    private void processSingleField(String fieldName, String originalValue, JSONObject row, MetaData metaData) {
        SensitiveDataEnhancer.SensitiveProcessResult result = SensitiveDataEnhancer.processSensitiveField((String)fieldName, (String)originalValue, (String)metaData.getSensitiveMaskStrategy(fieldName));
        if (result != null && result.isValid()) {
            row.put(fieldName, (Object)result.maskedValue());
            row.put(metaData.getSensitiveCipherField(fieldName), (Object)result.cipherValue());
            row.put(metaData.getSensitiveEncryptedField(fieldName), (Object)result.encryptedValue());
            log.debug("\u654f\u611f\u5b57\u6bb5\u5904\u7406\u5b8c\u6210: {} -> {}", (Object)fieldName, (Object)result.maskedValue());
        } else {
            log.warn("\u654f\u611f\u5b57\u6bb5\u5904\u7406\u5931\u8d25\u6216\u7ed3\u679c\u65e0\u6548: {}", (Object)fieldName);
        }
    }

    private SensitiveDataEnhancer.SensitiveDataResult processCrossTableMode(String entityName, JSONObject row, Map<String, String> crossTableFields, MetaData metaData) {
        log.debug("\u5904\u7406\u8de8\u8868\u6a21\u5f0f: {}, \u5b57\u6bb5\u6570={}", (Object)entityName, (Object)crossTableFields.size());
        String targetTable = crossTableFields.keySet().stream().findFirst().map(metaData::getSensitiveTargetTable).orElse(null);
        String relationField = crossTableFields.keySet().stream().findFirst().map(metaData::getSensitiveRelationField).orElse(null);
        if (targetTable == null || relationField == null) {
            log.warn("\u8de8\u8868\u6a21\u5f0f\u914d\u7f6e\u65e0\u6548: targetTable={}, relationField={}", (Object)targetTable, (Object)relationField);
            return null;
        }
        Object relationIdValue = row.opt(relationField);
        JSONObject cryptoData = relationIdValue == null ? this.buildNewCryptoData(crossTableFields, row, "", metaData) : this.buildOptimizedCryptoData(targetTable, relationIdValue.toString(), crossTableFields, row, metaData);
        if (!cryptoData.isEmpty()) {
            return new SensitiveDataEnhancer.SensitiveDataResult(targetTable, cryptoData, relationField);
        }
        return null;
    }

    private JSONObject buildNewCryptoData(Map<String, String> crossTableFields, JSONObject row, String relationId, MetaData metaData) {
        JSONObject cryptoData = new JSONObject();
        boolean hasProcessedFields = false;
        for (String fieldName : crossTableFields.keySet()) {
            SensitiveDataClassifier.DataClassificationResult classification;
            Object originalValue = row.opt(fieldName);
            if (originalValue == null || !this.shouldProcessField(classification = this.classifier.classify(fieldName, originalValue), fieldName, originalValue, "\u8de8\u8868\u65b0\u589e")) continue;
            SensitiveDataEnhancer.SensitiveProcessResult result = SensitiveDataEnhancer.processSensitiveField((String)fieldName, (String)originalValue.toString(), (String)metaData.getSensitiveMaskStrategy(fieldName));
            if (result != null && result.isValid()) {
                cryptoData.put(metaData.getSensitiveCipherField(fieldName), (Object)result.cipherValue());
                cryptoData.put(metaData.getSensitiveEncryptedField(fieldName), (Object)result.encryptedValue());
                row.put(fieldName, (Object)result.maskedValue());
                hasProcessedFields = true;
                log.debug("\u65b0\u589e\u52a0\u5bc6\u6570\u636e: {} -> {}", (Object)fieldName, (Object)result.maskedValue());
                continue;
            }
            log.warn("\u8de8\u8868\u65b0\u589e\u5b57\u6bb5\u5904\u7406\u5931\u8d25: {}", (Object)fieldName);
        }
        if (hasProcessedFields) {
            cryptoData.put(SOURCE_ENTITY_ID_FIELD, (Object)relationId);
            cryptoData.put(STATE_FIELD, (Object)VALID_STATE);
            log.debug("\u8de8\u8868\u52a0\u5bc6\u6570\u636e\u6784\u5efa\u5b8c\u6210\uff0c\u5305\u542b {} \u4e2a\u654f\u611f\u5b57\u6bb5", (Object)((cryptoData.length() - 2) / 2));
            return cryptoData;
        }
        log.debug("\u6240\u6709\u654f\u611f\u5b57\u6bb5\u90fd\u5df2\u8131\u654f\uff0c\u8df3\u8fc7\u52a0\u5bc6\u8868\u6570\u636e\u4fdd\u5b58");
        return new JSONObject();
    }

    private JSONObject buildOptimizedCryptoData(String targetTable, String relationId, Map<String, String> crossTableFields, JSONObject row, MetaData metaData) {
        JSONObject existingCrypto = this.queryExistingCryptoData(targetTable, relationId);
        if (existingCrypto == null) {
            log.debug("\u672a\u627e\u5230\u73b0\u6709\u52a0\u5bc6\u6570\u636e\uff0c\u6309\u65b0\u589e\u5904\u7406: {}", (Object)targetTable);
            return this.buildNewCryptoData(crossTableFields, row, relationId, metaData);
        }
        JSONObject newCryptoData = new JSONObject(existingCrypto.toString());
        boolean hasChanges = false;
        for (String fieldName : crossTableFields.keySet()) {
            String existingCipher;
            SensitiveDataClassifier.DataClassificationResult classification;
            Object newValue = row.opt(fieldName);
            if (newValue == null || !this.shouldProcessField(classification = this.classifier.classify(fieldName, newValue), fieldName, newValue, "\u8de8\u8868\u66f4\u65b0")) continue;
            String newStr = newValue.toString();
            if (SubstitutionCipherUtil.hasCipherChanged((String)newStr, (String)(existingCipher = existingCrypto.optString(metaData.getSensitiveCipherField(fieldName))))) {
                SensitiveDataEnhancer.SensitiveProcessResult result = SensitiveDataEnhancer.processSensitiveField((String)fieldName, (String)newStr, (String)metaData.getSensitiveMaskStrategy(fieldName));
                if (result == null || !result.isValid()) continue;
                newCryptoData.put(metaData.getSensitiveCipherField(fieldName), (Object)result.cipherValue());
                newCryptoData.put(metaData.getSensitiveEncryptedField(fieldName), (Object)result.encryptedValue());
                row.put(fieldName, (Object)result.maskedValue());
                hasChanges = true;
                log.debug("\u5b57\u6bb5\u503c\u53d1\u751f\u53d8\u5316\uff0c\u66f4\u65b0\u52a0\u5bc6\u6570\u636e: {} -> {}", (Object)fieldName, (Object)result.maskedValue());
                continue;
            }
            String maskedValue = SensitiveDataEnhancer.applyMaskingStrategy((String)fieldName, (String)newStr, (String)metaData.getSensitiveMaskStrategy(fieldName));
            row.put(fieldName, (Object)maskedValue);
            log.debug("\u5b57\u6bb5\u503c\u672a\u53d8\u5316\uff0c\u8df3\u8fc7\u52a0\u5bc6\u5904\u7406: {}", (Object)fieldName);
        }
        if (hasChanges) {
            newCryptoData.put(SOURCE_ENTITY_ID_FIELD, (Object)relationId);
            newCryptoData.put(OLD_ID_FIELD, newCryptoData.get("id"));
            newCryptoData.put(STATE_FIELD, (Object)VALID_STATE);
            newCryptoData.remove("id");
            log.debug("\u8de8\u8868\u66f4\u65b0\u6570\u636e\u6784\u5efa\u5b8c\u6210\uff0c\u6709\u5b57\u6bb5\u53d8\u5316");
            return newCryptoData;
        }
        log.debug("\u8de8\u8868\u66f4\u65b0\uff1a\u65e0\u5b57\u6bb5\u53d8\u5316\uff0c\u4e0d\u9700\u8981\u4fdd\u5b58\u65b0\u7684\u52a0\u5bc6\u8bb0\u5f55");
        return new JSONObject();
    }

    private JSONObject queryExistingCryptoData(String targetTable, String relationId) {
        try {
            String sql = "SELECT * FROM " + targetTable + " WHERE source_entity_id = '" + relationId + "' AND f_state = 'valid'";
            JSONObject queryParams = new JSONObject().put(PAGE_SIZE_PARAM, (Object)SINGLE_RESULT_SIZE).put(PAGE_NO_PARAM, (Object)SINGLE_RESULT_SIZE);
            JSONArray results = this.sqlService.querySQL(QUERY_EXISTING_CRYPTO_DESCRIPTION, sql, queryParams);
            return results.isEmpty() ? null : results.getJSONObject(0);
        }
        catch (Exception e) {
            this.handleFieldError("\u67e5\u8be2\u73b0\u6709\u52a0\u5bc6\u6570\u636e", targetTable + "(ID:" + relationId + ")", e);
            return null;
        }
    }
}

