package com.af.v4.system.common.jpa.sensitive;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;

/**
 * 敏感数据处理配置属性
 * 支持通过Nacos动态配置敏感数据处理功能的开启/关闭
 * <p>
 * 配置示例：
 * <pre>
 * security:
 *   sensitive:
 *     enabled: true                    # 是否启用敏感数据处理
 * </pre>
 */
@Configuration
@RefreshScope
@ConfigurationProperties(prefix = "security.sensitive")
public class SensitiveDataProperties {

    /**
     * 是否启用敏感数据处理功能
     * 默认：false（禁用）
     */
    private boolean enabled = true;

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String toString() {
        return STR."SensitiveDataProperties{enabled=\{enabled}}";
    }
}
