/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.job.processer;

import com.af.v4.system.common.job.processer.GlazeBasicTimer;
import com.af.v4.system.common.log.service.LogResolveService;
import com.af.v4.system.common.logic.service.LogicService;
import com.af.v4.system.common.plugins.concurrent.LogicBatchTaskProcessor;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import tech.powerjob.worker.core.processor.ProcessResult;

@Component
public class BatchLogicTimer
extends GlazeBasicTimer {
    private final Logger LOGGER = LoggerFactory.getLogger(BatchLogicTimer.class);
    protected final LogicService logicService;
    private static final String PARAMS_GET_BATCH_DATA_LOGIC_NAME = "getBatchDataLogicName";
    private static final String PARAMS_GET_BATCH_DATA_LOGIC_PARAMS = "getBatchDataLogicParams";
    private static final String PARAMS_HANDLE_DATA_LOGIC_NAME = "handleDataLogicName";

    public BatchLogicTimer(LogResolveService logResolveService, LogicService logicService) {
        super(logResolveService);
        this.logicService = logicService;
    }

    @Override
    public ProcessResult exec(JSONObject jobParams) {
        LogicBatchTaskProcessor processor = new LogicBatchTaskProcessor();
        JSONArray batchData = this.getBatchData(jobParams);
        JSONObject result = processor.process(batchData, item -> this.logicService.run(this.getHandleLogicName(jobParams), item));
        return new ProcessResult(true, result.toString());
    }

    public JSONArray getBatchData(JSONObject jobParams) {
        return (JSONArray)this.logicService.run(jobParams.getString(PARAMS_GET_BATCH_DATA_LOGIC_NAME), jobParams.getJSONObject(PARAMS_GET_BATCH_DATA_LOGIC_PARAMS));
    }

    public String getHandleLogicName(JSONObject jobParams) {
        return jobParams.getString(PARAMS_HANDLE_DATA_LOGIC_NAME);
    }
}

