/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.file.utils;

import com.af.v4.system.common.core.constant.FileConstants;
import com.af.v4.system.common.core.enums.OSType;
import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.resource.config.ResourceConfig;
import java.io.File;
import org.springframework.stereotype.Component;

@Component
public final class FilePathUtil {
    private final ApplicationService applicationService;
    private final ResourceConfig resourceConfig;

    public FilePathUtil(ApplicationService applicationService, ResourceConfig resourceConfig) {
        this.applicationService = applicationService;
        this.resourceConfig = resourceConfig;
    }

    public static String fileExt(String filename) {
        String[] array = filename.split("\\.");
        return array[array.length - 1].toLowerCase();
    }

    public String getFileRootPathByServer() {
        Object rootPath = this.resourceConfig.getFileRootPath();
        if (rootPath == null) {
            OSType osType = ApplicationService.getOSType();
            rootPath = osType == OSType.WINDOWS ? "D:" + File.separatorChar + "resources" : File.separatorChar + "usr" + File.separatorChar + "local" + File.separatorChar + "tomcat" + File.separatorChar + "files";
        }
        return rootPath;
    }

    public String getFileExtraPathByServer(String resourceType) {
        return File.separatorChar + this.applicationService.getApplicationName() + File.separatorChar + (String)FileConstants.RESOURCE_TYPE_2_DIR.get(resourceType);
    }

    public String getFileFullPathByServer(String resourceType, String fileName) {
        return this.getFileRootPathByServer() + this.getFileExtraPathByServer(resourceType) + fileName;
    }

    public String getFileDownloadUrlByServer(String resourceType, String fileName) {
        return "/resource" + this.getFileExtraPathByServer(resourceType) + fileName;
    }

    public String getFileExtraPathBySSO(String resourceType, String bucketName) {
        return "/" + (String)FileConstants.RESOURCE_TYPE_2_DIR.get(resourceType);
    }

    public String getFileFullPathBySSO(String resourceType, String fileName, String bucketName) {
        return this.getFileExtraPathBySSO(resourceType, bucketName) + fileName;
    }

    public String getFileDownloadUrlBySSO(String resourceType, String fileName, String bucketName) {
        return "/minio/" + (bucketName == null || bucketName.isEmpty() ? this.applicationService.getApplicationName() : bucketName) + this.getFileExtraPathBySSO(resourceType, bucketName) + fileName;
    }
}

