/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.file.service;

import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import java.io.InputStream;
import java.util.HashMap;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class MinioService {
    private final MinioClient minioClient;

    public MinioService(MinioClient minioClient) {
        this.minioClient = minioClient;
    }

    public void upload(MultipartFile file, String fileName, String bucketName) throws Exception {
        boolean bucketExists = this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
        if (!bucketExists) {
            this.minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
        }
        String originalFilename = file.getOriginalFilename();
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put("originalFilename", originalFilename);
        this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(fileName)).userMetadata(metaData)).stream(file.getInputStream(), file.getSize(), -1L).contentType(file.getContentType()).build());
    }

    public InputStream download(String bucketName, String fileName) throws Exception {
        if (fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        return this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(fileName)).build());
    }
}

