/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.expression.report.core;

import com.af.v4.system.common.expression.core.Delegate;
import com.af.v4.system.common.expression.core.Program;
import com.af.v4.system.common.expression.report.core.Report;
import org.dom4j.Element;

public class Cell {
    public int row;
    public int column;
    public int rowSpan;
    public int columnSpan;
    public String css = "";
    public String width = "";
    public String height = "";
    public String isDown = "true";
    public String content;
    public String type = "";
    public Delegate delegate;
    public Report report;

    public Cell(Element ele) {
        this.row = Integer.parseInt(ele.attributeValue("row"));
        this.column = Integer.parseInt(ele.attributeValue("column"));
        this.rowSpan = Integer.parseInt(ele.attributeValue("rowspan"));
        this.columnSpan = Integer.parseInt(ele.attributeValue("columnspan"));
        this.content = ele.attributeValue("content");
        this.css = ele.attributeValue("css");
        this.width = ele.attributeValue("width");
        this.height = ele.attributeValue("height");
        this.type = ele.attributeValue("type");
        this.isDown = ele.attributeValue("isDown");
    }

    public Cell(int row, int column, int rowSpan, int columnSpan, String content) {
        this.row = row;
        this.column = column;
        this.rowSpan = rowSpan;
        this.columnSpan = columnSpan;
        this.content = content;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public void compile() {
        if (this.content == null || this.content.trim().isEmpty()) {
            return;
        }
        Program prog = new Program(this.content);
        this.delegate = prog.parse();
    }

    public Object invoke() {
        if (this.delegate == null) {
            return "";
        }
        return this.delegate.invoke(this.report.vars);
    }

    public Cell clone() {
        Cell result = new Cell(this.row, this.column, this.rowSpan, this.columnSpan, this.content);
        if (this.width != null && !this.width.isEmpty()) {
            result.width = this.width;
        }
        if (this.height != null && !this.height.isEmpty()) {
            result.height = this.height;
        }
        if (this.css != null && !this.css.isEmpty()) {
            result.css = this.css;
        }
        if (this.delegate != null) {
            result.delegate = this.delegate;
        }
        if (this.report != null) {
            result.report = this.report;
        }
        return result;
    }

    public String toString() {
        return this.row + ":" + this.column;
    }
}

