package com.af.v4.system.common.expression.exception;

import java.io.Serial;

/**
 * 表达式执行异常，将显示执行异常的位置信息
 *
 * @author hns
 */
public class ExpressionException extends RuntimeException {
    @Serial
    private static final long serialVersionUID = 1L;

    public ExpressionException(String source, int pos) {
        super(getMessage(source, pos));
    }

    public ExpressionException(String source, int pos, Exception cause) {
        super(getMessage(source, pos), cause);
    }

    private static String getMessage(String source, int pos) {
        String beforeErrorContent = source.substring(0, pos).trim();
        int length = beforeErrorContent.length();
        if (length > 1000) {
            beforeErrorContent = STR."""
以上省略......
\{beforeErrorContent.substring(length - 1000)}""";
        }
        String afterErrorContent = source.substring(pos);
        int afterErrorContentIndex = afterErrorContent.indexOf("\n");
        if (afterErrorContentIndex == -1) {
            return STR."\{beforeErrorContent.trim()} <- \{afterErrorContent}";
        } else {
            return STR."""
\{beforeErrorContent.trim()} <- \{afterErrorContent.substring(0, afterErrorContentIndex)}
后续省略......""";
        }
    }
}
