package com.af.v4.system.common.excel.core;

import com.af.v4.system.common.core.constant.ServiceNameConstants;
import com.af.v4.system.common.core.proxy.logic.ILogicServiceProxy;
import com.alibaba.excel.write.handler.RowWriteHandler;
import com.alibaba.excel.write.handler.context.RowWriteHandlerContext;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/**
 * excel 行写入监听
 */
@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class ExportStaffProgressWriteHandler implements RowWriteHandler {

    private static final Logger LOGGER = LoggerFactory.getLogger(ExportStaffProgressWriteHandler.class);
    private final ILogicServiceProxy logicService;
    private double row = 50; // 导出进度从 50%开始, 前50%为sql执行进度
    private int totalRows = 0; // 总行数
    private int currentRow = 0; // 当前行数
    private String userId = ""; // 用户id
    private String taskName = ""; // 任务名(导出任务名为 导出文件名)

    public ExportStaffProgressWriteHandler(ILogicServiceProxy logicService) {
        this.logicService = logicService;
    }

    public void init(int totalRows, String taskName, String userId) {
        this.totalRows = totalRows;
        this.userId = userId;
        this.taskName = taskName;
    }

    /**
     * 监听行写入之后
     */
    @Override
    public void afterRowCreate(RowWriteHandlerContext context) {
        Integer relativeRowIndex = context.getRelativeRowIndex();
        Boolean isHead = context.getHead();
        if (relativeRowIndex != null && !isHead) {
            int current = ++currentRow;
            double progress = ((double) current / totalRows);
            progress = 50 + (progress * 50);
            progress = Math.ceil(progress * 100) / 100.0;

            // 控制 每 5% 推送一次进度
            if (progress > row) {
                JSONObject progressJson = new JSONObject()
                        .put("taskName", taskName)
                        .put("progress", progress);

                // 增加消息类型, 方便 af-system-vue 消息提示判断
                JSONObject message = new JSONObject()
                        .put("messageType", "task")
                        .put("progress", progressJson);

                JSONArray userList = new JSONArray().put(userId);

                JSONObject param = new JSONObject()
                        .put("userList", userList)
                        .put("event", message.toString());

                logicService.remoteRun(ServiceNameConstants.SYSTEM_SERVICE, "sendMessage", String.valueOf(param));

                row += 5;
            }
        }
    }
}
