package com.af.v4.system.common.excel.convert;

import com.alibaba.excel.converters.string.StringNumberConverter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.DataFormatData;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;

/**
 * excel 中的 数字格式日期（读取到是数字 excel 中展示为字符串） 处理转换器
 * Number to yyyy-MM-dd HH:mm:ss
 */
public class NumberToDateConverter extends StringNumberConverter {

    @Override
    public String convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty,
                                    GlobalConfiguration globalConfiguration) {
        if (CellDataTypeEnum.DATE == cellData.getType() || !"General".equals(cellData.getDataFormatData().getFormat())) {
            DataFormatData dataFormatData = cellData.getDataFormatData();
            dataFormatData.setFormat("yyyy-MM-dd HH:mm:ss");
        }
        return super.convertToJavaData(cellData, contentProperty, globalConfiguration);
    }

}
