package com.af.v4.system.common.elasticsearch.config;

import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.datasource.enums.DbType;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * 该类用于配置全局数据，数据源
 */
@Component
public class AFLogstashGlobalConfig {

    private final ElasticSearchConfig esConfig;
    @Value("${logstash.allFieldDefineName}")
    private String allFieldDefineName;
    @Value("${logstash.ESTargetIndex}")
    private String ESTargetIndex;
    @Value("${logstash.JDBCDriverPath}")
    private String JDBCDriverPath;

    public AFLogstashGlobalConfig(ElasticSearchConfig esConfig) {
        this.esConfig = esConfig;
    }

    public String getJDBCDriverClassName() {
        return DynamicDataSource.getWrapper().getConfig().getDriverClassName();
    }

    public DbType getDBType() {
        return DynamicDataSource.getWrapper().getDbType();
    }

    public String getAllFieldDefineName() {
        return allFieldDefineName;
    }

    public String getESTargetIndex() {
        return ESTargetIndex;
    }

    public String getJDBCDriverPath() {
        return JDBCDriverPath;
    }

    public String getDBurl() {
        return DynamicDataSource.getWrapper().getConfig().getUrl();
    }

    public String getDBUsername() {
        return DynamicDataSource.getWrapper().getConfig().getUsername();
    }

    public String getDBPassword() {
        return DynamicDataSource.getWrapper().getConfig().getPassword();
    }

    public String getESHost() {
        String host = esConfig.getHost();
        String port = esConfig.getPort();
        return STR."\{host}:\{port}";
    }
}
