/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.elasticsearch.config;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ElasticSearchConfig {
    @Value(value="${elasticsearch.host}")
    private String host;
    @Value(value="${elasticsearch.port}")
    private String port;

    @Bean
    public ElasticsearchClient client() {
        int portInt = Integer.parseInt(this.port);
        RestClient restClient = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.host, portInt)}).build();
        RestClientTransport transport = new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper());
        return new ElasticsearchClient((ElasticsearchTransport)transport);
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }
}

