/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.elasticsearch.utils;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import co.elastic.clients.elasticsearch.indices.DeleteIndexRequest;
import co.elastic.clients.elasticsearch.indices.GetIndexRequest;
import co.elastic.clients.elasticsearch.indices.GetIndexResponse;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import co.elastic.clients.elasticsearch.indices.IndexState;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import jakarta.json.Json;
import jakarta.json.stream.JsonParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AFElasticSearchIndexUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AFElasticSearchIndexUtils.class);
    private final ElasticsearchClient client;

    public AFElasticSearchIndexUtils(ElasticsearchClient client) {
        this.client = client;
    }

    public void addWithMapping(String indexName, String mapping) {
        boolean exist = this.isExist(indexName);
        if (exist) {
            LOGGER.error("\u7d22\u5f15\uff1a{}\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u521b\u5efa\uff01\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\uff01", (Object)indexName);
            return;
        }
        try (ElasticsearchTransport transport = (ElasticsearchTransport)this.client._transport();){
            JsonpMapper mapper = transport.jsonpMapper();
            JsonParser parser = Json.createParser((Reader)new StringReader(mapping));
            CreateIndexRequest createIndexRequest = new CreateIndexRequest.Builder().index(indexName).mappings((TypeMapping)TypeMapping._DESERIALIZER.deserialize(parser, mapper)).build();
            this.client.indices().create(createIndexRequest);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LOGGER.info("\u521b\u5efaElasticSearch\u7d22\u5f15[{}] \u6210\u529f\uff01", (Object)indexName);
        LOGGER.info("\u7d22\u5f15[{}] \u7684\u7ed3\u6784\u4e3a\uff1a{}", (Object)indexName, (Object)mapping);
    }

    public boolean isExist(String indexName) {
        boolean exists = false;
        try {
            this.client.indices().get(GetIndexRequest.of(i -> i.index(indexName, new String[0])));
            exists = true;
        }
        catch (ElasticsearchException | IOException e) {
            LOGGER.error("\u53d1\u751f\u62a5\u9519", e);
        }
        return exists;
    }

    public void delete(String indexName) {
        boolean exist = this.isExist(indexName);
        if (!exist) {
            LOGGER.warn("\u7d22\u5f15[{}] \u4e0d\u5b58\u5728\uff01", (Object)indexName);
            return;
        }
        DeleteIndexRequest deleteIndexRequest = DeleteIndexRequest.of(i -> i.index(indexName, new String[0]));
        try {
            this.client.indices().delete(deleteIndexRequest);
        }
        catch (IOException e) {
            LOGGER.error(e.toString());
        }
    }

    public void showInfo(String indexName) {
        GetIndexResponse response;
        boolean exist = this.isExist(indexName);
        if (!exist) {
            LOGGER.warn("\u7d22\u5f15[{}] \u4e0d\u5b58\u5728\uff01", (Object)indexName);
            return;
        }
        GetIndexRequest getIndexRequest = GetIndexRequest.of(i -> i.index(indexName, new String[0]));
        try {
            response = this.client.indices().get(getIndexRequest);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        IndexState target = response.get(indexName);
        assert (target != null);
        Map aliases = target.aliases();
        TypeMapping mappings = target.mappings();
        IndexSettings settings = target.settings();
        LOGGER.info("aliases");
        LOGGER.info("aliases");
        LOGGER.info(aliases.toString());
        LOGGER.info("mappings");
        assert (mappings != null);
        LOGGER.info(mappings.toString());
        LOGGER.info("settings");
        assert (settings != null);
        LOGGER.info(settings.toString());
    }
}

