/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.elasticsearch.utils;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.elasticsearch.core.search.Hit;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AFElasticSearchDocUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AFElasticSearchDocUtils.class);
    private final ElasticsearchClient client;

    public AFElasticSearchDocUtils(ElasticsearchClient client) {
        this.client = client;
    }

    public void insert(String indexName, List<BulkOperation> data) {
        BulkResponse response;
        try {
            response = this.client.bulk(e -> e.index(indexName).operations(data));
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        LOGGER.info("\u5b58\u50a8[{}]\u6761\u6570\u636e\u6210\u529f\uff01\u5171\u8017\u65f6\uff1a{}ms", (Object)data.size(), (Object)response.took());
    }

    private JSONArray formatResult(SearchResponse<Object> response) {
        JSONArray result = new JSONArray();
        List hits = response.hits().hits();
        for (Hit hit : hits) {
            String id = hit.id();
            Map source = (Map)hit.source();
            Map highlight = hit.highlight();
            JSONObject temp = new JSONObject();
            JSONArray highlightArr = new JSONArray();
            assert (source != null);
            Set sourceKeySet = source.keySet();
            temp.put("id", (Object)id);
            for (Object o : sourceKeySet) {
                Object o1 = source.get(o);
                if (o1 instanceof Integer) {
                    temp.put(o.toString(), o1);
                    continue;
                }
                temp.put(o.toString(), (Object)o1.toString());
            }
            int size = highlight.size();
            if (size > 0) {
                Set highlightKeySet = highlight.keySet();
                for (String s : highlightKeySet) {
                    List list = (List)highlight.get(s);
                    for (String s1 : list) {
                        highlightArr.put((Object)s1);
                    }
                }
            }
            temp.put("highlight", (Object)highlightArr);
            result.put((Object)temp);
        }
        return result;
    }

    public void delete(String indexName, List<BulkOperation> ids) {
        try {
            BulkResponse response = this.client.bulk(e -> e.index("aaa").operations(ids));
            long took = response.took();
            LOGGER.info("\u5df2\u5b8c\u6210\u5220\u9664\uff0c\u7528\u65f6\uff1a{}ms", (Object)took);
        }
        catch (IOException e2) {
            LOGGER.error(e2.toString());
        }
    }

    public JSONArray search(SearchRequest request) {
        try {
            SearchResponse search = this.client.search(request, Object.class);
            return this.formatResult((SearchResponse<Object>)search);
        }
        catch (IOException e) {
            LOGGER.error("\u67e5\u8be2\u5931\u8d25\uff01");
            LOGGER.error(e.toString());
            return new JSONArray();
        }
    }
}

