package com.af.v4.system.common.elasticsearch.common;

/**
 * 生成ElasticSearch Mapping字符串
 */
public class ESMappingGenerator {
    private final StringBuilder sb;

    /**
     * 用于判断是否是第一个字段，之后的字段在拼接之前，多加一个 “，”（逗号）
     */
    private boolean isFirstField;

    /**
     * 构造函数，进行初始化
     */
    public ESMappingGenerator() {
        this.sb = new StringBuilder();
        sb.append("{\"properties\":{");
        this.isFirstField = true;
    }

    /**
     * 添加非文字字段
     *
     * @param fieldName 字段名
     * @param fieldType 字段类型，可以使用ESFieldType中的常量来指定
     */
    public void addField(String fieldName, String fieldType) {
        if (this.isFirstField) {
            sb.append("\"").append(fieldName).append("\"").append(":{\"type\":\"").append(fieldType).append("\", \"copy_to\":\"all_field_for_search\"}");
            this.isFirstField = false;
        } else {
            sb.append(",\"").append(fieldName).append("\"").append(":{\"type\":\"").append(fieldType).append("\", \"copy_to\":\"all_field_for_search\"}");
        }
    }

    /**
     * 添加文字字段，并指定分词器
     *
     * @param fieldName 字段名
     * @param analyzer  分词器，可以使用ESAnalyzer中的常量来指定
     */
    public void addFieldWithAnalyzer(String fieldName, String analyzer) {
        if (this.isFirstField) {
            sb.append("\"").append(fieldName).append("\"").append(":{\"type\":\"text\", \"analyzer\":\"").append(analyzer).append("\", \"copy_to\":\"all_field_for_search\"}");
            this.isFirstField = false;
        } else {
            sb.append(",\"").append(fieldName).append("\"").append(":{\"type\":\"text\", \"analyzer\":\"").append(analyzer).append("\", \"copy_to\":\"all_field_for_search\"}");
        }
    }

    /**
     * 返回最终结果，并在其后添加两个反括号 "}}"
     *
     * @return 最终结果字符串
     */
    public String result() {
        sb.append(",\"all_field_for_search\":{\"type\":\"text\",\"analyzer\":\"ik_max_word\",\"store\":true}}}");
        return sb.toString();
    }
}
