/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.utils.StringUtils;
import com.af.v4.system.common.datasource.enums.DbType;
import com.af.v4.system.common.datasource.wrapper.AfDataSourceWrapper;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DynamicDataSource
extends AbstractRoutingDataSource {
    public static final String DEFAULT_DATASOURCE_NAME = "master";
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicDataSource.class);
    private static final ScopedValue<Deque<String>> LOOKUP_KEY_HOLDER = ScopedValue.newInstance();
    private static Map<String, AfDataSourceWrapper> dataSourceInfo = new HashMap<String, AfDataSourceWrapper>(3);

    public DynamicDataSource(Map<String, AfDataSourceWrapper> dataSources) {
        dataSourceInfo = dataSources;
        super.setTargetDataSources(new HashMap(1));
        super.afterPropertiesSet();
    }

    public DynamicDataSource() {
    }

    public static String getDataSource() {
        Deque deque = LOOKUP_KEY_HOLDER.orElse(new ArrayDeque());
        return deque.peek() != null ? (String)deque.peek() : DEFAULT_DATASOURCE_NAME;
    }

    public static <T> T withDataSource(String dataSource, Supplier<T> supplier) {
        if (dataSource == null) {
            return supplier.get();
        }
        Deque currentStack = LOOKUP_KEY_HOLDER.orElse(new ArrayDeque());
        if (!currentStack.isEmpty() && ((String)currentStack.peek()).equals(dataSource)) {
            return supplier.get();
        }
        ArrayDeque<String> newStack = new ArrayDeque<String>(currentStack);
        String dataSourceStr = StringUtils.isEmpty((String)dataSource) ? DEFAULT_DATASOURCE_NAME : dataSource;
        newStack.push(dataSourceStr);
        try {
            return (T)ScopedValue.where(LOOKUP_KEY_HOLDER, newStack).call(supplier::get);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void withDataSource(String dataSource, Runnable runnable) {
        DynamicDataSource.withDataSource(dataSource, () -> {
            runnable.run();
            return null;
        });
    }

    public static <T> T withDataSource(String dataSource, Function<JSONObject, T> runnable) {
        return DynamicDataSource.withDataSource(dataSource, runnable, null);
    }

    public static <T> T withDataSource(String dataSource, Function<JSONObject, T> runnable, JSONObject params) {
        return (T)DynamicDataSource.withDataSource(dataSource, () -> runnable.apply(params));
    }

    public static Map<String, AfDataSourceWrapper> getDataSourceMap() {
        return dataSourceInfo;
    }

    public static AfDataSourceWrapper getWrapper() {
        String dataSource = DynamicDataSource.getDataSource();
        AfDataSourceWrapper wrapper = DynamicDataSource.getDataSourceMap().get(dataSource);
        if (wrapper == null) {
            LOGGER.error("\u4e0d\u5b58\u5728\u7684\u6570\u636e\u6e90\uff1a[{}]", (Object)dataSource);
            throw new ServiceException("\u4e0d\u5b58\u5728\u7684\u6570\u636e\u6e90", Integer.valueOf(500));
        }
        return wrapper;
    }

    public static DbType getDbType() {
        return DynamicDataSource.getWrapper().getDbType();
    }

    protected DataSource determineTargetDataSource() {
        String lookupKey = this.determineCurrentLookupKey();
        AfDataSourceWrapper wrapper = dataSourceInfo.get(lookupKey);
        if (wrapper == null) {
            wrapper = dataSourceInfo.get(DEFAULT_DATASOURCE_NAME);
        }
        if (wrapper == null) {
            throw new ServiceException("\u4e0d\u5b58\u5728\u7684\u6570\u636e\u6e90 [" + lookupKey + "]");
        }
        return wrapper.getDataSource();
    }

    protected String determineCurrentLookupKey() {
        return DynamicDataSource.getDataSource();
    }
}

