/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource.dialects.id;

import com.af.v4.system.common.datasource.dialects.Dialect;
import com.af.v4.system.common.datasource.dialects.DialectException;
import com.af.v4.system.common.datasource.dialects.JdbcUtil;
import com.af.v4.system.common.datasource.dialects.StrUtils;
import com.af.v4.system.common.datasource.dialects.Type;
import com.af.v4.system.common.datasource.dialects.enums.GenerationType;
import com.af.v4.system.common.datasource.dialects.id.IdGenerator;
import java.sql.Connection;

public class IdentityIdGenerator
implements IdGenerator {
    private String table;
    private String column;

    public IdentityIdGenerator(String table, String column) {
        this.table = table;
        this.column = column;
    }

    @Override
    public GenerationType getGenerationType() {
        return GenerationType.IDENTITY;
    }

    @Override
    public String getIdGenName() {
        return "IDENTITY";
    }

    @Override
    public Boolean dependOnAutoIdGenerator() {
        return false;
    }

    @Override
    public Object getNextID(Connection con, Dialect dialect, Type dataType) {
        if (!Boolean.TRUE.equals(dialect.ddlFeatures.getSupportsIdentityColumns())) {
            throw new DialectException("Dialect '" + String.valueOf(dialect) + "' does not support identity type");
        }
        String sql = Type.BIGINT.equals((Object)dataType) ? dialect.ddlFeatures.getIdentitySelectStringBigINT() : dialect.ddlFeatures.getIdentitySelectString();
        if (StrUtils.isEmpty(sql) || "NOT_SUPPORT".equals(sql)) {
            throw new DialectException("Dialect '" + String.valueOf(dialect) + "' does not support identity type");
        }
        sql = StrUtils.replaceFirst(sql, "_table__col", this.table + "_" + this.column);
        return JdbcUtil.qryOneObject(con, sql, new Object[0]);
    }

    @Override
    public IdGenerator newCopy() {
        return new IdentityIdGenerator(this.table, this.column);
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }
}

